package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/**
 * @author wuyang
 * @desc 日志工具栏
 * @date 20224/12/12
 */
public final class LogUtils {


    public static String MODULE_EE = "executionEngine";


    private static String MODULE_EE_DESC = "EE - 执行引擎";


    /**
     * 请求的状态码
     */
    public static String SUCCESS = "1";
    public static String WARING = "0";

    /**
     * 敏捷数据日志前缀
     */
    public static final String AGILEDATA_LOG_PREFIX = "agiledata_";


    private static final Logger LOGGER = LoggerFactory.getLogger(LogUtils.class);

    /**
     * 构建日志
     *
     * @param step
     * @param code
     * @param input
     * @param result
     * @param suggestion
     */
    public static void buildAgileLog(String step, String code, String input,
                                     String result, String suggestion) {
        Log log;
        //同意处理下入参出餐
        JSONObject inputObject = new JSONObject();
        inputObject.put("input", input);
        input = inputObject.toJSONString();
        JSONObject resultObject = new JSONObject();
        resultObject.put("result", result);
        result = resultObject.toJSONString();
        //代表执行成功
        if (SUCCESS.equalsIgnoreCase(code)) {
            log = buildSuccessLog(MODULE_EE_DESC, step, input, result, suggestion);
        } else if (WARING.equalsIgnoreCase(code)) {
            log = buildWaringLog(MODULE_EE_DESC, step, input, result, suggestion);
        } else {
            log = buildErrorLog(MODULE_EE_DESC, step, code, input, result, suggestion);
        }
        LOGGER.error(AGILEDATA_LOG_PREFIX + MODULE_EE + "_请求过程为_" + JsonUtil.getJsonString(log));
    }


    private static Log buildSuccessLog(String productComponent, String step, String input,
                                       String result, String suggestion) {
        return new Log("SUCCESS", productComponent, step, SUCCESS, input, result, suggestion);
    }

    private static Log buildWaringLog(String productComponent, String step, String input,
                                      String result, String suggestion) {
        return new Log("WARING", productComponent, step, WARING, input, result, suggestion);
    }

    private static Log buildErrorLog(String productComponent, String step, String code, String input,
                                     String result, String suggestion) {
        return new Log("ERROR", productComponent, step, code, input, result, suggestion);
    }


    public static class Log {
        String logType;
        String productComponent;
        String step;
        String code;
        String input;
        String result;
        String suggestion;

        public Log(String logType, String productComponent, String step, String code, String input,
                   String result, String suggestion) {
            this.logType = logType;
            this.productComponent = productComponent;
            this.step = step;
            this.code = code;
            this.input = input;
            this.result = result;
            this.suggestion = suggestion;
        }

        public String getInput() {
            return input;
        }

        public void setInput(String input) {
            this.input = input;
        }

        public String getLogType() {
            return logType;
        }

        public void setLogType(String logType) {
            this.logType = logType;
        }

        public String getProductComponent() {
            return productComponent;
        }

        public void setProductComponent(String productComponent) {
            this.productComponent = productComponent;
        }

        public String getStep() {
            return step;
        }

        public void setStep(String step) {
            this.step = step;
        }

        public String getCode() {
            return code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getResult() {
            return result;
        }

        public void setResult(String result) {
            this.result = result;
        }

        public String getSuggestion() {
            return suggestion;
        }

        public void setSuggestion(String suggestion) {
            this.suggestion = suggestion;
        }
    }

    public static void main(String[] args) {
        Set<String> actionParams = new HashSet<>(2);
        Set<String> sysParamKeys = new HashSet<>(2);
        actionParams.add("asssqq");
        actionParams.add("27902");
        Map<String, Object> reqMap = new HashMap<>(4);
        reqMap.put("actionId", "fsa12d2344fs");
        reqMap.put("tenantId", "agiledemo");
        reqMap.put("actionParams", actionParams);
        reqMap.put("sysParams", sysParamKeys);
        //正确的请求日志
        buildAgileLog("getExecutionRule", LogUtils.SUCCESS,
                JsonUtil.getJsonString(reqMap), "", "");
        //错误的请求日志
        buildAgileLog("getExecutionRule", "502",
                JsonUtil.getJsonString(reqMap), "", "地端MQ短线，请联系客户检查");
    }
}
