package com.digiwin.athena.executionengine.util;

import com.digiwin.athena.executionengine.enumtype.ResultTypeEnum;
import com.digiwin.athena.executionengine.model.ServiceResult;

/**
 * @description: 执行引擎服务返回结果工具类
 * @author: renwm
 * @date: 2020/6/22 15:29
 */
public class ServiceResultUtils {

    private ServiceResultUtils() {
    }

    /**
     * 根据类型获取返回结果对象
     *
     * @param resultTypeEnum
     * @return
     */
    public static ServiceResult getResultByTypeEnum(ResultTypeEnum resultTypeEnum) {
        return new ServiceResult(resultTypeEnum.getStatus(), resultTypeEnum.getMsg());
    }

    /**
     * 根据类型 和返回结果  获取结果对象
     *
     * @param resultTypeEnum
     * @param result
     * @return
     */
    public static ServiceResult getResultByTypeEnum(ResultTypeEnum resultTypeEnum, Object result) {
        return new ServiceResult(resultTypeEnum.getStatus(), resultTypeEnum.getMsg(), result);
    }

    /**
     * 根据执行状态和结果 获取返回对象
     * @param status
     * @param result
     * @return
     */
    public static ServiceResult getResultByStatusObj(Boolean status, String actionId, Object result) {
        if (status) {
            return getResultByTypeEnum(ResultTypeEnum.EXECUTE_RESULT_SUCCESS, result);
        }
        return new ServiceResult(false,String.format("服务%s调用响应失败",actionId), result);
    }

    /**
     * 根据状态和消息 获取返回结果对象
     * @param status
     * @param msg
     * @return
     */
    public static ServiceResult getResultByStatusMsg(Boolean status, String msg) {

        return new ServiceResult(status, msg);
    }
}
