/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.executionengine.component.action.IActionExecutionProcessor;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.component.param.CaseParam;
import com.digiwin.athena.executionengine.component.param.MultiPathParam;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.component.param.PullingParam;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.ResultStatusConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.DataDescription;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.service.facade.execution.asyc.AsyncTask;
import com.digiwin.athena.executionengine.service.facade.execution.asyc.IAsyncExecutor;
import com.digiwin.athena.executionengine.service.facade.mapping.param.ParamMappingUtils;
import com.digiwin.athena.executionengine.service.facade.schema.dynamic.IDynamicCalculateBuilder;
import com.digiwin.athena.executionengine.service.facade.transform.IAggregator;
import com.digiwin.athena.executionengine.service.facade.transform.IFlattener;
import com.digiwin.athena.executionengine.service.facade.transform.MetaNode;
import com.digiwin.athena.executionengine.service.srp.ITransSrp;
import com.digiwin.athena.executionengine.util.ContextUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class ActionBase
implements IActionExecutionProcessor {
    protected abstract Object actionExecute(ExecuteContext var1, Map<String, Object> var2, ActionParam var3);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean execute(ExecuteContext context, ActionParam actionParam) {
        this.prepare(context, actionParam);
        try {
            ExecuteContext executeContext = context;
            synchronized (executeContext) {
                context.wait();
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        return actionParam.getActionState() == ResultStatusConstant.EXECUTE_SUCCESS.getCode();
    }

    public void prepare(ExecuteContext context, ActionParam actionParam) {
        if (actionParam.getActionState() == ResultStatusConstant.EXECUTE_SUCCESS.getCode()) {
            return;
        }
        this.doPrepare(context, actionParam);
    }

    @Override
    public List<Map<String, Object>> postProcessBeforeExecution(List<Map<String, Object>> request, ActionParam actionParam) {
        if (CollectionUtils.isEmpty(actionParam.getApiMeta()) || CollectionUtils.isEmpty(request)) {
            return request;
        }
        Map<String, Object> stringObjectMap = request.get(0);
        List data = (List)stringObjectMap.get("data");
        IAggregator iAggregator = ContextUtils.getBean(IAggregator.class, new Object[0]);
        Map<String, MetaNode> nodeMap = iAggregator.analyzeAPIMetaData(actionParam.getApiMeta());
        MetaNode node = nodeMap.values().stream().max(Comparator.comparingInt(MetaNode::getDepth)).get();
        int maxDepth = node.getDepth();
        if (maxDepth == 1) {
            return data;
        }
        JSONObject result = new JSONObject();
        iAggregator.processAggregation(result, data, 1, maxDepth, nodeMap);
        return (List)result.get((Object)"result");
    }

    @Override
    public Object postProcessAfterExecution(Object response, ActionParam actionParam) {
        if (CollectionUtils.isEmpty(actionParam.getApiMeta())) {
            return response;
        }
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        inputMap.put("", response);
        List<Map<String, Object>> flattenData = ContextUtils.getBean(IFlattener.class, new Object[0]).flatten("", inputMap);
        HashMap<String, List<Map<String, Object>>> result = new HashMap<String, List<Map<String, Object>>>();
        result.put("data", flattenData);
        return result;
    }

    @Override
    public Object dynamicCompute(ExecuteContext context, Object response, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String actionMode = metaObj.getString("actionMode");
        if (!"dynamic".equals(actionMode)) {
            return response;
        }
        if (response == null || !(response instanceof Map)) {
            return response;
        }
        Map result = (Map)response;
        if (!result.containsKey("data")) {
            return response;
        }
        List dataList = (List)result.get("data");
        DataDescription dataDescription = context.getInputParam().getDataDescription();
        JSONObject dynamicSchema = dataDescription.getDynamicSchema();
        JSONArray recast = new JSONArray();
        if (MapUtils.isNotEmpty((Map)dynamicSchema)) {
            dynamicSchema.forEach((k, v) -> {
                JSONObject buildSchema;
                String beanName = CommonConstant.CALCULATE_BUILDER_MAP.get(k);
                if (StringUtils.isNotEmpty((CharSequence)beanName) && MapUtils.isNotEmpty((Map)(buildSchema = ContextUtils.getBean(beanName, IDynamicCalculateBuilder.class).build(v, actionParam)))) {
                    recast.add((Object)buildSchema);
                }
            });
        }
        List listOfMaps = (List)JSON.parseObject((String)JSON.toJSONString((Object)recast), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
        ServiceResult serviceResult = ContextUtils.getBean(ITransSrp.class, new Object[0]).runTrans(context.getTenantId(), listOfMaps, dataList);
        if (serviceResult.getSuccess().booleanValue() && serviceResult.getData() != null && dynamicSchema.get((Object)"groupBy") != null) {
            List data = (List)serviceResult.getData();
            JSONObject aggregation = actionParam.getAggregation();
            JSONArray dimensions = aggregation.getJSONArray("dimensions");
            ArrayList<String> dimensionNames = new ArrayList<String>();
            for (int i = 0; i < dimensions.size(); ++i) {
                dimensionNames.add(dimensions.getJSONObject(i).getString("data_name"));
            }
            JSONArray groupArray = dynamicSchema.getJSONArray("groupBy");
            ArrayList<String> groupList = new ArrayList<String>();
            for (int i = 0; i < groupArray.size(); ++i) {
                String groupField = groupArray.getJSONObject(i).getString("content");
                groupList.add(groupField);
            }
            for (Map datum : data) {
                for (Map.Entry entry : datum.entrySet()) {
                    if (groupList.contains(entry.getKey()) || !dimensionNames.contains(entry.getKey())) continue;
                    datum.put(entry.getKey(), "default");
                }
            }
        }
        result.put("data", serviceResult.getData());
        return result;
    }

    public boolean exec(ExecuteContext context, ActionParam actionParam) {
        Object res;
        Object dynamicComputeRes;
        String actionId = actionParam.getActionId();
        boolean isForeach = actionParam.isForeach();
        ParamMappingUtils paramMappingUtils = new ParamMappingUtils(context, actionId);
        ArrayList<Object> apiData = new ArrayList<Object>();
        ServiceResult serviceResult = paramMappingUtils.mappingReqParam(apiData, actionParam.getRequestParams());
        if (!serviceResult.getSuccess().booleanValue()) {
            return false;
        }
        List<Map<String, Object>> apiParams = paramMappingUtils.mergeApiData(apiData);
        boolean foreachRes = true;
        if (apiParams.size() > 1 && !isForeach) {
            return false;
        }
        apiParams = this.postProcessBeforeExecution(apiParams, actionParam);
        for (Map<String, Object> apiParam : apiParams) {
            context.setCurrentActionId(actionId);
            Object resp = ContextUtils.getBean(actionParam.getActionName(), ActionBase.class).actionExecute(context, apiParam, actionParam);
            context.addActionResponse(actionId, resp, isForeach, actionParam.getActionType());
            if (!foreachRes || context.isExecuteStatus()) continue;
            foreachRes = false;
        }
        if (apiParams.size() == 0) {
            context.setCurrentActionId(actionId);
            Object resp = ContextUtils.getBean(actionParam.getActionName(), ActionBase.class).actionExecute(context, new HashMap<String, Object>(), actionParam);
            context.addActionResponse(actionId, resp, isForeach, actionParam.getActionType());
            if (foreachRes && !context.isExecuteStatus()) {
                foreachRes = false;
            }
        }
        if ((dynamicComputeRes = this.dynamicCompute(context, res = this.postProcessAfterExecution(context.getActionResponse(actionId), actionParam), actionParam)) != null) {
            context.getActionResponse().put(actionId, dynamicComputeRes);
        }
        if (context.isRelease()) {
            this.releaseMemory(context, actionParam);
        }
        return foreachRes;
    }

    private void releaseMemory(ExecuteContext context, ActionParam actionParam) {
        List<ParamBase> params = actionParam.getParams();
        params.forEach(param -> {
            if (param instanceof PullingParam) {
                PullingParam pullingParam = (PullingParam)param;
                context.getActionResponse().remove(pullingParam.getSource());
                context.getParamGetDataHandler().removeReadContext(pullingParam.getSource());
                context.getDataMappingManager().release(actionParam.getActionId(), pullingParam.getSource());
            }
        });
    }

    private void doPrepare(ExecuteContext context, ActionParam actionParam) {
        HashSet<String> sourceSet = new HashSet<String>();
        List finalParams = actionParam.getParams().stream().filter(paraObj -> paraObj instanceof PullingParam).map(pullingParam -> (PullingParam)pullingParam).filter(pullingParam -> sourceSet.add(pullingParam.getSource())).collect(Collectors.toList());
        long count = finalParams.stream().filter(pullingParam -> context.getActionResponse().containsKey(pullingParam.getSource())).count();
        long failedCnt = sourceSet.stream().filter(k -> context.getActionParam((String)k).getActionState() == ResultStatusConstant.EXECUTED_FAILD.getCode()).count();
        if ((long)finalParams.size() == count) {
            ContextUtils.getBean(IAsyncExecutor.class, new Object[0]).addTask(new AsyncTask(context, actionParam));
            return;
        }
        if (failedCnt > 0L) {
            ContextUtils.getBean(IAsyncExecutor.class, new Object[0]).addTask(new AsyncTask(context, actionParam, false));
            return;
        }
        context.getActionQueue().addNode(actionParam.getActionId(), sourceSet);
        for (ParamBase paraObj2 : finalParams) {
            paraObj2.parEvalAndExclude(context);
        }
    }

    private boolean specialParamHandle(ExecuteContext context, ActionParam actionParam) {
        List specialParams = actionParam.getParams().stream().filter(paraObj -> paraObj instanceof CaseParam || paraObj instanceof MultiPathParam).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(specialParams)) {
            return true;
        }
        for (ParamBase paraObj2 : specialParams) {
            boolean parVal = paraObj2.parEvalAndExclude(context);
            if (parVal) continue;
            return false;
        }
        return true;
    }
}

