/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.aop.Debug;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.core.container.RunInfo;
import com.digiwin.athena.executionengine.dto.runinfo.MetricExecutionDto;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="MetricAction")
public class MetricAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricAction.class);

    @Override
    @Debug
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject respObj = null;
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("token", context.getToken());
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            headerMap.put("routerKey", context.getRouterKey());
            headerMap.put("locale", context.getLocale());
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("actionId", actionParam.getActionId());
            param.put("tenantId", context.getTenantId());
            param.put("eocMaps", context.getInputParam().getEocMaps());
            param.put("roles", context.getInputParam().getRoles());
            param.put("sysParam", context.getInputParam().getSysParam());
            param.put("dataDescription", context.getInputParam().getDataDescription());
            param.put("param", new HashMap());
            String jsonParam = JsonResolverUtils.toJsonString(param);
            String httpRespContent = HttpClientUtils.doPost(ModuleProperty.EE_URL, headerMap, jsonParam);
            if (httpRespContent == null) {
                context.setExecuteStatus(false);
                LOGGER.error("\u6267\u884c\u5f15\u64ce\u8c03\u7528\u6307\u6807Action\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1anull", (Object)actionParam.getActionId(), (Object)jsonParam);
                return null;
            }
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528\u6307\u6807Action\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{actionParam.getActionId(), jsonParam, httpRespContent});
            respObj = ServiceResponseUtils.getServiceComposerResp(httpRespContent);
            context.setExecuteStatus(true);
            if (respObj == null) {
                return new JSONObject();
            }
            if (context.isDebug()) {
                RunInfo runInfo = (RunInfo)JSONObject.parseObject((String)JSONObject.toJSONString((Object)respObj.get((Object)"runInfo")), RunInfo.class);
                MetricExecutionDto metricExecutionDto = new MetricExecutionDto();
                String uuid = UUID.randomUUID().toString();
                metricExecutionDto.setUuid(uuid);
                metricExecutionDto.setMetricId(actionParam.getActionId());
                metricExecutionDto.setMetricName(actionParam.getMetaObj().getString("actionName"));
                context.getRunInfo().getMetricExecutionDto().getChildren().add(metricExecutionDto);
                context.getRunInfo().getActionExecutionMap().put(uuid, runInfo.getActionExecutionDtos());
                context.getRunInfo().getActionExecutionMap().putAll(runInfo.getActionExecutionMap());
            }
            return respObj;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u8c03\u7528\u6307\u6807Action\u6267\u884c\u5f02\u5e38", (Throwable)e);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0004");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.METRIC);
            context.setExecuteErrorMessage(executeErrorMessage);
            context.setExecuteStatus(false);
            throw e;
        }
    }
}

