/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.component.param.ParamFactory;
import com.digiwin.athena.executionengine.service.facade.analyzer.AbstractAnalyzerBase;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="engineMetaActionAnalyzer")
public class MetaActionAnalyzer
extends AbstractAnalyzerBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetaActionAnalyzer.class);

    @Override
    protected void analysisHandler(JSONObject executionRule) {
        if (MapUtils.isEmpty((Map)executionRule)) {
            return;
        }
        JSONArray actions = executionRule.getJSONArray("actions");
        if (CollectionUtils.isEmpty((Collection)actions)) {
            return;
        }
        for (int i = 0; i < actions.size(); ++i) {
            JSONObject actionJson = actions.getJSONObject(i);
            String actionId = actionJson.getString("actionId");
            ActionParam actionParam = MetaActionAnalyzer.getLocalContext().getActionParam(actionId);
            if (null == actionParam) continue;
            this.analysisParam(actionParam, actionJson);
        }
    }

    private void analysisParam(ActionParam actionParam, JSONObject actionJson) {
        actionParam.setActionJson(actionJson);
        actionParam.setForeach(actionJson.getBooleanValue("forEach"));
        JSONArray paramArray = actionJson.getJSONArray("params");
        if (CollectionUtils.isEmpty((Collection)paramArray)) {
            return;
        }
        for (int i = 0; i < paramArray.size(); ++i) {
            JSONObject item = paramArray.getJSONObject(i);
            ParamBase paramBase = ParamFactory.createParam(item);
            if (null == paramBase) continue;
            actionParam.getParams().add(paramBase);
        }
    }
}

