/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Sort;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="sortStep")
public class SortSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SortSolutionStepAnalyzer.class);
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object sortData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("sortStep\u5f00\u59cb\u6267\u884csortData==null:{}", (Object)(sortData == null ? "true" : "false"));
        JSONArray sortDataArray = JSONArray.parseArray((String)JSONObject.toJSONString((Object)sortData, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteMapNullValue}));
        if (sortDataArray != null && !sortDataArray.isEmpty()) {
            Object resultData;
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put(dataKey, sortDataArray);
            JSONObject criteriaDefinition = new JSONObject();
            criteriaDefinition.put("technique", (Object)"sorts");
            JSONObject sortJson = new JSONObject();
            ArrayList<Sort> newSortList = new ArrayList<Sort>();
            for (Sort sort : solutionStep.getSort()) {
                String content;
                Sort newSort = new Sort();
                BeanUtils.copyProperties((Object)sort, (Object)newSort);
                if ("calculate".equals(sort.getDataObject().getContentType())) {
                    content = newSort.getDataObject().getContent();
                    newSort.getDataObject().setContent(this.getComputeColumnName(solutionStep.getComputeList(), content));
                    newSortList.add(newSort);
                    continue;
                }
                if (!"field".equals(sort.getDataObject().getContentType())) continue;
                content = sort.getDataObject().getContent();
                JSONObject data = sortDataArray.getJSONObject(0);
                Set dataFieldKeys = data.keySet();
                if (!dataFieldKeys.contains(content)) continue;
                newSortList.add(newSort);
            }
            if (CollectionUtils.isNotEmpty(newSortList)) {
                sortJson.put("sort", (Object)JSONArray.parseArray((String)JSONArray.toJSONString(newSortList)));
                criteriaDefinition.put("schema", (Object)sortJson);
                JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
                LOGGER.info("sortStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
                TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
                TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
                resultData = transEngine.runEngine(transDataManger);
            } else {
                resultData = sortData;
            }
            if (solutionStep.getLimit() != null) {
                SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
                ISolutionStepAnalyzer limitStep = (ISolutionStepAnalyzer)ContextUtils.getBean("limitStep", new Object[0]);
                limitStep.executeStep(solutionStep, stepIndex, context);
            } else if (CollectionUtils.isNotEmpty(solutionStep.getUnion())) {
                ISolutionStepAnalyzer unionStep = (ISolutionStepAnalyzer)ContextUtils.getBean("unionStep", new Object[0]);
                unionStep.executeStep(solutionStep, stepIndex, context);
            } else {
                SolutionStepExecutionFacade.getTransDataMap().put(solutionStep.getAlias(), resultData);
                SolutionStepExecutionFacade.getTransDataMap().remove(dataKey);
            }
        }
    }

    private String getComputeColumnName(JSONObject computeList, String computeName) {
        int i = 0;
        JSONArray computeArray = computeList.getJSONArray(computeName);
        if (i < computeArray.size()) {
            JSONObject compute = computeArray.getJSONObject(i);
            return compute.getString("newField");
        }
        return "";
    }
}

