/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.schema.datacenter;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.dto.schema.DateFormatDto;
import com.digiwin.athena.executionengine.dto.schema.SchemaTransDto;
import com.digiwin.athena.executionengine.service.facade.schema.AbstractSchemaConvertor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class DataCenterSelectConvertor
extends AbstractSchemaConvertor {
    @Override
    public void convert(SchemaTransDto schemaTransDto) {
        JSONArray selects = (JSONArray)schemaTransDto.getDynamicSchema();
        JSONObject computeObj = schemaTransDto.getComputeObj();
        if (CollectionUtils.isEmpty((Collection)selects)) {
            return;
        }
        JSONObject mappingFields = (JSONObject)schemaTransDto.getReqData();
        List<JSONObject> calculateObj = selects.stream().map(o -> ((JSONObject)o).getJSONObject("dataObject")).filter(item -> "calculate".equals(item.getString("contentType"))).filter(item -> "number".equals(item.getString("dataType"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(calculateObj)) {
            schemaTransDto.getQuerySchema().put("dataType", (Object)2);
            this.handleSelect(schemaTransDto.getQuerySchema(), selects, mappingFields);
            this.handleDateCompute(schemaTransDto, selects, mappingFields);
            return;
        }
        calculateObj.forEach(select -> {
            JSONObject sObj = select;
            schemaTransDto.getQuerySchema().getJSONArray("measures").add((Object)this.genMeasureObj(sObj, computeObj, mappingFields));
        });
    }

    private void handleDateCompute(SchemaTransDto schemaTransDto, JSONArray selects, JSONObject mappingFields) {
        List<JSONObject> calculateObj = selects.stream().map(o -> (JSONObject)o).filter(item -> "calculate".equals(item.getString("contentType"))).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(calculateObj)) {
            return;
        }
        JSONObject computeObj = schemaTransDto.getComputeObj();
        ArrayList dateFormatDtos = new ArrayList();
        calculateObj.forEach(item -> {
            String content = item.getString("content");
            JSONArray computeList = computeObj.getJSONArray(content);
            if (CollectionUtils.isEmpty((Collection)computeList)) {
                return;
            }
            computeList.forEach(o -> {
                JSONObject computeItem = (JSONObject)o;
                String calFunction = computeItem.getString("calFunction");
                if ("DateFormat".equals(calFunction)) {
                    JSONArray params = computeItem.getJSONArray("params");
                    JSONObject fieldParam = params.getJSONObject(0);
                    JSONObject formatParam = params.getJSONObject(1);
                    String field = fieldParam.getString("content");
                    String fieldType = fieldParam.getString("dataType");
                    String format = formatParam.getString("content");
                    DateFormatDto dateFormatDto = new DateFormatDto(field, CommonConstant.DATA_CENTER_FUNCTION_MAP.get(format));
                    dateFormatDto.setFieldType(fieldType);
                    dateFormatDtos.add(dateFormatDto);
                }
            });
        });
        if (CollectionUtils.isNotEmpty(dateFormatDtos)) {
            dateFormatDtos.forEach(dateFormatDto -> {
                JSONObject computeObject = new JSONObject();
                computeObject.put("field", (Object)dateFormatDto.getField());
                computeObject.put("dataType", (Object)dateFormatDto.getFieldType().toUpperCase());
                computeObject.put("expression", (Object)("date_format([" + dateFormatDto.getField() + "],'" + dateFormatDto.getFormat() + "')"));
                schemaTransDto.getQuerySchema().getJSONArray("computedFields").add((Object)computeObject);
                JSONObject groupObject = new JSONObject();
                groupObject.put("field", (Object)dateFormatDto.getField());
                groupObject.put("name", (Object)dateFormatDto.getField());
                groupObject.put("dataType", (Object)dateFormatDto.getFieldType().toUpperCase());
                if (!this.dimensionsIsExist(schemaTransDto.getQuerySchema(), dateFormatDto.getField())) {
                    schemaTransDto.getQuerySchema().getJSONArray("dimensions").add((Object)groupObject);
                }
            });
        }
    }

    private void handleSelect(JSONObject querySchema, JSONArray selects, JSONObject mappingFields) {
        selects.forEach(select -> {
            JSONObject obj = (JSONObject)select;
            JSONObject dataObj = obj.getJSONObject("dataObject");
            String contentType = dataObj.getString("contentType");
            if (!"calculate".equals(contentType)) {
                String dataType = dataObj.getString("dataType");
                String content = dataObj.getString("content");
                JSONObject groupObject = new JSONObject();
                groupObject.put("field", (Object)mappingFields.getString(content));
                groupObject.put("name", (Object)content);
                groupObject.put("dataType", (Object)dataType.toUpperCase());
                if (!this.dimensionsIsExist(querySchema, content)) {
                    querySchema.getJSONArray("dimensions").add((Object)groupObject);
                }
            }
        });
    }

    private JSONObject genMeasureObj(JSONObject dataObject, JSONObject computeObj, JSONObject mappingFields) {
        String content = dataObject.getString("content");
        JSONArray computeList = computeObj.getJSONArray(content);
        JSONObject funObj = computeList.getJSONObject(0);
        String function = funObj.getString("calFunction");
        JSONObject measureObj = new JSONObject();
        JSONObject aggregator = new JSONObject();
        aggregator.put("function", (Object)function);
        aggregator.put("distinct", (Object)false);
        measureObj.put("aggregator", (Object)aggregator);
        JSONArray params = funObj.getJSONArray("params");
        JSONObject fieldParam = params.getJSONObject(0);
        String field = fieldParam.getString("content");
        String dataType = fieldParam.getString("dataType");
        measureObj.put("field", (Object)mappingFields.getString(field));
        measureObj.put("name", (Object)field);
        measureObj.put("dataType", (Object)dataType.toUpperCase());
        return measureObj;
    }
}

