package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.CommonConstant;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingHandler;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;

import java.util.List;

/**
 * @description:
 * @author: renwm
 * @date: 2020/6/15 22:40
 */
public class InputParam extends ParamBase {

    /**
     * paramType (param,sysParam)
     */
    private String paramType;

    public String getParamType() {
        return paramType;
    }

    public String getExecutionParamType() {
        return executionParamType;
    }

    /**
     * responseActionId （ExecutionParam，ExecutionSysParam）
     */
    private String executionParamType;

    @Override
    protected void initProperty(JSONObject paramObj) {
        this.paramType = paramObj.getString(MetaDataConstant.ACTIONS_PARAMS_TYPE);
        executionParamType = FieldNameConstant.INPUT_PARAM_PARAM.equalsIgnoreCase(paramType) ? CommonConstant.EXECUTION_PARAM : CommonConstant.EXECUTION_SYSPARAM;
    }

    @Override
    public boolean eval(ExecuteContext context) {
        return true;
    }

    @Override
    public boolean isCollectionRoot(DataMappingManager dataMappingManager, String requestActionId) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.isCollectionParam("$");
    }

    @Override
    public boolean isCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.isCollectionParam(paramPath);
    }

    @Override
    public boolean isObjectCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.isObjectCollectionParam(paramPath);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String fixedPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.getPathDataSize(paramPath, fixedPath);
    }

    /**
     * 根据paramPath，获取上一级节点的实际路径作为限定范围路径，取该范围路径下的数据量
     *
     * @param dataMappingManager
     * @param requestActionId
     * @param paramPath
     * @return
     */
    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.getPathDataSize(paramPath);
    }

    @Override
    public boolean pathIsExistsInData(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.pathIsExistsInData(paramPath);
    }


    @Override
    public int countCollectionInPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.countCollectionInPath(paramPath);
    }


    /**
     * 表明这个数据来自执行引擎入参
     *
     * @param context
     * @return
     */
    @Override
    public String getSrcActionId(ExecuteContext context) {
        return executionParamType;
    }

    @Override
    public Object getData(ExecuteContext context, String jsonPath) {
        Object data = getInputData(context);
        return context.getParamGetDataHandler().getData(executionParamType, data, jsonPath);

    }

    /**
     * 根据paramType取源数据上的对应节点
     *
     * @param context
     * @return
     */
    private Object getInputData(ExecuteContext context) {
        if (FieldNameConstant.INPUT_PARAM_SYSPARAM.equalsIgnoreCase(paramType)) {
            return context.getInputParam().getSysParam();
        }
        if (context.getInputParam().getParas() != null) {
            return context.getInputParam().getParas();
        }
        return context.getInputParam().getParam();
    }

    @Override
    public Object getData(ExecuteContext context, DataMappingManager dataMappingManager,
                          String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        String jsonPath = dataMappingHandler.getConcreteJsonPath(paramPath);
        return getData(context, jsonPath);
    }

    @Override
    public int getDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String jsonPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.getZoneDataSize(paramPath, jsonPath);
    }

    @Override
    public int getRootSize(DataMappingManager dataMappingManager, String requestActionId) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.getZoneDataSize("$", "");
    }

    @Override
    public List<String> getCollectionPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.getCollectionParamPathList(paramPath);
    }

    /**
     * 通过参数映射关系设置数据的实际下标
     *
     * @param paramPath
     * @param pos
     */
    @Override
    public void setParentPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        dataMappingHandler.setParentNodePosition(paramPath, pos);
    }

    /**
     * 通过参数映射关系获取数据的实际下标
     *
     * @param paramPath
     */
    @Override
    public void setPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        dataMappingHandler.setNodePosition(paramPath, pos);
    }

    /**
     * 通过参数映射关系获取数据的真实的JsonPath
     *
     * @param paramPath
     */
    @Override
    public String getDataJsonPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        DataMappingHandler dataMappingHandler = dataMappingManager.getDatMappingHandler(requestActionId, executionParamType);
        return dataMappingHandler.getDataJsonPath(paramPath);
    }
}
