package com.digiwin.athena.executionengine.constant;

import java.util.HashMap;
import java.util.Map;

/**
 * @description: 全局通用常量定义
 * @author: renwm
 * @date: 2020/6/18 14:51
 */
public final class CommonConstant {

    public static final String SERVER_TIME = "serverTime";
    public static final String EMPTY_KEY = "";
    public static final String DATA_KEY = "data";

    private CommonConstant() {
    }

    public static final String CLIENT_PLACEHOLDER_DEFAULT_PREFIX = "$(";

    public static final String CLIENT_PLACEHOLDER_DEFAULT_SUFFIX = ")";
    public static final String CLIENT_PLACEHOLDER_SPECIAL_PREFIX = "$";
    /**
     * 分隔符 点
     */
    public static final String SEPARATOR_DOT = ".";

    /**
     * 根节点
     */
    public static final String ROOT_NODE = ".ROOT";

    /**
     * 执行引擎入参
     */
    public static final String EXECUTION_PARAM = "ExecutionParam";
    /**
     * 执行引擎入参的sysParam
     */
    public static final String EXECUTION_SYSPARAM = "ExecutionSysParam";

    /**
     * 数组位置标记，暂用作记号
     */
    public static final String SEPARATOR_POS = ".pos";

    /**
     * json path的前缀
     */
    public static final String JSON_PATH_PREFIX = "$";
    public static final String JSON_ARRAY_PATH_PREFIX = "$[*]";

    /**
     * json path 后缀
     */
    public static final String JSON_PATH_ARRAY_SUFFIX = "[*]";

    public static final String HTTP_HEADER_CONTENT_TYPE_KEY = "Content-Type";

    public static final String HTTP_HEADER_CONTENT_TYPE_VULE = "application/json;charset=UTF-8";

    /**
     * 集合初始化值
     */
    public static final int INITIAL_CAPACITY_INPUT_PARAM = 1 << 1;
    public static final int INITIAL_CAPACITY_THEMEMAP_DATAINFO = 1 << 2;

    /**
     * 数值1
     */
    public static final int SIZE_ONE = 1;

    /**
     * 不满足条件的取值
     */
    public static final int SIZE_NO_EQUAL = -1;

    /**
     * 标志位初始位置
     */
    public static final int POS_INIT = 0;

    /**
     * 标志位第一个位置
     */
    public static final int POS_INIT_ONE = 1;

    /**
     * size大小为0
     */
    public static final int SIZE_ZERO = 0;

    /**
     * 相等
     */
    public static final int COMPARE_EQUAL = 0;

    /**
     * 递增
     */
    public static final int INCREASE_ONE = 1;

    /**
     * 是否是根节点
     */
    public static final boolean IS_ROOT = true;

    /**
     * 是否是根节点
     */
    public static final boolean IS_NOT_ROOT = false;

    /**
     * 升序
     */
    public static final String ORDER_ASC = "asc";


    /**
     * 链路信息
     */
    public final static String CHAIN_INFO = "chainInfo";
    public final static String PTX_ID = "PtxId";
    public final static String TRACE_ID = "traceId";
    public static final String MONITOR_PROCESS_TYPE = "monitorProcessType";

    public static final String APP_NAME = "ExecutionEngine";
    public static final String APP_CODE = "ExecutionEngine";
    public static final String MESSAGE_ID = "messageId";

    //去年本月的第一天
    public static final String FIRSTDAYOFMONTHYEARAGO = "firstDayOfMonthYearAgo";

    //上个月的第一天
    public static final String FIRSTDATEOFLASTMONTH = "firstDateOfLastMonth";

    //上个月的最后一天
    public static final String LASTDATEOFLASTMONTH = "lastDateOfLastMonth";

    //本月第一天
    public static final String FIRSTDATEOFMONTH = "firstDateOfMonth";
    //本月最后一天
    public static final String LASTDATEOFMONTH = "lastDateOfMonth";

    //本年第一天
    public static final String FIRSTDAYOFTHISYEAR = "firstDayOfThisYear";
    //本年最后一天
    public static final String LASTDAYOFTHISYEAR = "lastDayOfThisYear";
    //自定义
    public static final String CUSTOM = "custom";

    public static final String LOGITYPE_AND = "and";
    public static final String LOGITYPE_OR = "or";
    public static final String PARAM = "param";
    /**
     * 指标 敏数1.0
     */
    public static final String METRIC = "metric";
    /**
     * 指标表 敏数1.0 数据集
     */
    public static final String METRIC_DATASET = "metricDataset";

    /**
     * 敏捷数据2.0  数据集
     */
    public static final String DATASET = "dataset";
    public static final String SUB_QUERY = "subquery";

    /**
     * 权限过滤类型比较符
     */
    public static final Map<String, String> PERMISSION_FILTER_TYPE_COMPARISON_MAP = new HashMap<String, String>() {
        {
            put("eq", "eq");
            put("ne", "not_eq");
            put("like", "like");
            put("rl", "start_like");
            put("nrl", "not_start_like");
            put("ll", "end_like");
            put("nll", "not_end_like");
            put("gt", "gt");
            put("gte", "ge");
            put("lt", "lt");
            put("lte", "le");
            put("between", "between");
            put("in", "in");
            put("nin", "not_in");
            put("null", "null");
            put("nn", "not_null");
        }
    };


    /**
     * 新架构
     * 权限过滤类型比较符
     */
    public static final Map<String, String> FILTER_TYPE_COMPARISON_MAP = new HashMap<String, String>() {
        {
            //key 语义 value 模型对应
            put("eq", "eq");
            put("not_eq", "not_eq");
            put("neq", "not_eq");
            put("fm", "like");
            put("pm", "start_like");
            put("nrl", "not_start_like");
            put("sm", "end_like");
            put("nll", "not_end_like");
            put("gt", "gt");
            put("gte", "ge");
            put("lt", "lt");
            put("lte", "le");
            put("between", "between");
            put("in", "in");
            put("nin", "not_in");
            put("null", "null");
            put("not_null", "not_null");
        }
    };

    /**
     * 新架构
     * 权限过滤类型比较符
     */
    public static final Map<String, Integer> DATA_CENTER_FILTER_TYPE_COMPARISON_MAP = new HashMap<String, Integer>() {
        {
            //0-eq,1-not_eq,2-like,3-not_like,4-in,5-not_in,6-ge,7-le,8-gt,9-lt,10-between,11-not_between,12-null,13-not_null
            //key 语义 value 模型对应
            put("eq", 0);
            put("not_eq", 1);
            put("neq", 1);
            put("fm", 2);
/*            put("pm", "start_like");
            put("nrl", "not_start_like");
            put("sm", "end_like");
            put("nll", "not_end_like");*/
            put("gt", 8);
            put("gte", 6);
            put("lt", 9);
            put("lte", 7);
            put("between", 10);
            put("in", 4);
            put("nin", 5);
            put("null", 12);
            put("not_null", 13);
        }
    };

    public static final Map<String, Integer> DATASET_PERMISSION_FILTER_TYPE_COMPARISON_MAP = new HashMap<String, Integer>() {
        {
            put("eq", 0);
            put("ne", 1);
            put("like", 2);
            /*put("rl", "start_like");
            put("nrl", "not_start_like");
            put("ll", "end_like");
            put("nll", "not_end_like");*/
            put("gt", 8);
            put("gte", 6);
            put("lt", 9);
            put("lte", 7);
            put("between", 10);
            put("in", 4);
            put("nin", 5);
            put("null", 12);
            put("nn", 13);
        }
    };

    public static final Map<String, String> DATA_CENTER_FUNCTION_MAP = new HashMap<String, String>() {
        {
            //key 语义 value 模型对应
            put("y_M", "%y%m");
            put("M", "%m");
        }
    };

    public static final Map<String, String> CONVERTOR_MAP = new HashMap<String, String>() {
        {
            put("filter", "filterConvertor");
            put("groupBy", "groupConvertor");
            put("having", "havingConvertor");
            put("sort", "sortConvertor");
        }
    };

    public static final Map<String, String> DATA_CENTER_CONVERTOR_MAP = new HashMap<String, String>() {
        {
            put("filter", "dataCenterFilterConvertor");
            put("groupBy", "dataCenterGroupConvertor");
            put("having", "dataCenterHavingConvertor");
            put("select", "dataCenterSelectConvertor");
        }
    };

    public static final Map<String, String> CALCULATE_BUILDER_MAP = new HashMap<String, String>() {
        {
            put("filter", "filterBuilder");
            put("groupBy", "groupBuilder");
            put("having", "havingBuilder");
            put("sort", "sortBuilder");
        }
    };

    /**
     * 数值100
     */
    public static final String STRING_ONE_HUNDRED = "100";

    /**
     * 计算精度默认值
     */
    public static final int THIRTY_TWO = 32;
    public static final String STRING_THIRTY_TWO = "32";

    /**
     * 数值-1
     */
    public static final String STRING_NEGATIVE_ONE = "-1";
    /**
     * 数值1
     */
    public static final String STRING_ONE = "1";
}