package com.digiwin.athena.executionengine.exception;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/7/7
 */
public class BusinessException extends DWRuntimeException {
    @Override
    public String getErrorType() {
        return "application";
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     */
    public BusinessException(String message) {
        super(message);
    }

    public BusinessException(ErrorCodeEnum errorCode) {
        super(errorCode.getCode(), errorCode.getMessage());
    }

    /**
     * 构造一个基本异常.
     *
     * @param errorCode 错误编码
     * @param message   信息描述
     */
    public BusinessException(String errorCode, String message) {
        super(errorCode, message);
    }

    public BusinessException(String errorCode, String message, String... messageArgs) {
        super(errorCode, message, messageArgs);
    }

    /**
     * 构造一个基本异常.
     *
     * @param message 信息描述
     * @param cause   根异常类（可以存入任何异常）
     */
    public BusinessException(String message, Throwable cause) {
        super(message, cause);
    }

    /**
     * 构造一个基本异常.
     *
     * @param errorCode 错误码
     * @param message   信息描述
     * @param cause     根异常类（可以存入任何异常）
     */
    public BusinessException(String errorCode, String message, Throwable cause) {
        super(errorCode, message, cause);
    }
}
