package com.digiwin.athena.executionengine.service.srp.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.CustomException;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.model.trans.MicroTrans;
import com.digiwin.athena.executionengine.service.srp.ITransSrp;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/5/5
 */
@Service
public class TransSrp implements ITransSrp {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransSrp.class);

    @Override
    public ServiceResult runTrans(String tenantId, String ruleId, Map<String, Object> reqMap, Map<String, Object> eocMap) {
        ServiceResult serviceResult = new ServiceResult(false);
        LOGGER.info("开始执行Trans处理:{}", JSON.toJSONString(reqMap));
        if (reqMap == null) {
            LOGGER.warn("执行Trans处理入参为空");
            return serviceResult;
        }
        // 1.根据ruleId获取规则
        JSONObject ruleJsonObj = PlatformServiceUtils.getRuleInfo(ruleId);
        if (ruleJsonObj == null) {
            LOGGER.error("通过ruleId:{}未获取到TransRule", ruleId);
            throw ExceptionUtils.buildCustomException(ErrorCodeEnum.TRANS_RULE_NOT_FOUND, ruleId);
        }
        LOGGER.info("调用接口返回的rule规则:{}", ruleJsonObj);

        ////如果版本是1，trans定义上是没有version字段
        String version = ruleJsonObj.getString("version");
        // 3.根据规则和数据源执行数据流程
        if (version == null) {
            LOGGER.error("请切换到Trans V2版本，V1版本不再维护");
            throw new CustomException(ErrorCodeEnum.TRANS_RULE_VERSION_ERROR.getCode(), ErrorCodeEnum.TRANS_RULE_VERSION_ERROR.getMessage());
        }
        TransDataManger transDataManger = new TransDataManger(ruleJsonObj, reqMap, tenantId, eocMap);
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
        serviceResult.setData(transEngine.runEngine(transDataManger));
        serviceResult.setSuccess(true);
        LOGGER.info("Trans执行返回结果:{}", JSON.toJSONString(serviceResult.getData()));
        return serviceResult;
    }

    @Override
    public ServiceResult runTransByTransAction(ExecuteContext context, String ruleId, Map<String, Object> reqMap) {
        ServiceResult serviceResult = new ServiceResult(false);
        LOGGER.info("开始执行Trans处理:{}", JSON.toJSONString(reqMap));
        if (reqMap == null) {
            LOGGER.warn("执行Trans处理入参为空");
            return serviceResult;
        }
        // 1.根据ruleId获取规则
        JSONObject ruleJsonObj = PlatformServiceUtils.getRuleInfoParaller(ruleId, context.getToken(), context.getTenantId());
        if (ruleJsonObj == null) {
            LOGGER.error("通过ruleId:{}未获取到TransRule", ruleId);
            throw ExceptionUtils.buildCustomException(ErrorCodeEnum.TRANS_RULE_NOT_FOUND, ruleId);
        }
        LOGGER.info("调用接口返回的rule规则:{}", ruleJsonObj);

        ////如果版本是1，trans定义上是没有version字段
        String version = ruleJsonObj.getString("version");
        // 3.根据规则和数据源执行数据流程
        if (version == null) {
            LOGGER.error("请切换到Trans V2版本，V1版本不再维护");
            throw new CustomException(ErrorCodeEnum.TRANS_RULE_VERSION_ERROR.getCode(), ErrorCodeEnum.TRANS_RULE_VERSION_ERROR.getMessage());
        }
        TransDataManger transDataManger = new TransDataManger(ruleJsonObj, reqMap, context.getTenantId(), context.getEocMap(),context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
        serviceResult.setData(transEngine.runEngine(transDataManger));
        serviceResult.setSuccess(true);
        LOGGER.info("Trans执行返回结果:{}", JSON.toJSONString(serviceResult.getData()));
        return serviceResult;
    }

    @Override
    public ServiceResult runTrans(String tenantId, List<Map<String, Object>> recasts, Object data) {
        ServiceResult serviceResult = new ServiceResult(false);
        try {
            MicroTrans microTrans = TranCovertUtils.buildTransByRecast(recasts);
            TransDataManger transDataManger = new TransDataManger(JsonUtil.getObject(JsonUtil.getJsonString(microTrans)), data, tenantId);
            TransEngine transEngine = ContextUtils.getBean(TransEngine.class);
            serviceResult.setData(transEngine.runEngine(transDataManger));
            serviceResult.setSuccess(true);
            LOGGER.info("Trans执行返回结果:{}", JSON.toJSONString(serviceResult.getData()));
        } catch (Exception e) {
            LOGGER.error("原数据：" + JsonUtil.getJsonString(data) + "recasts：" + JsonUtil.getJsonString(recasts));
            e.printStackTrace();
        }
        return serviceResult;
    }
}
