package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.service.facade.analyzer.IDataValueExtractor;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2025/6/6
 */
@Service
public class DataValueExtractor implements IDataValueExtractor {
    @Override
    public Object extract(String key, String operator, Object rightData) {
        if ("in".equals(operator) || "nin".equals(operator)) {
            return handleCollectionCase(key, rightData);
        } else {
            return handleSingleValueCase(key, rightData);
        }
    }


    private String handleCollectionCase(String key, Object rightData) {
        List<String> values = new ArrayList<>();

        if (rightData instanceof JSONArray) {
            ((JSONArray) rightData).forEach(item ->
                    values.add(extractValueFromItem(key, item))
            );
        } else {
            values.add(extractValueFromItem(key, rightData));
        }

        return String.join(",", values);
    }

    private Object handleSingleValueCase(String key, Object rightData) {
        Object data = rightData;

        if (data instanceof JSONArray && ((JSONArray) data).size() > 0) {
            data = ((JSONArray) data).get(0);
        }

        if (data instanceof JSONObject) {
            return ((JSONObject) data).get(key);
        }

        return null;
    }

    private String extractValueFromItem(String key, Object item) {
        if (item instanceof JSONObject) {
            return String.valueOf(((JSONObject) item).get(key));
        }
        return String.valueOf(item);
    }
}
