package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.TransConstant;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/24
 */
@Service
public class SortsTransformer implements ICriteriaTransformer {
    @Override
    public JSONObject analysisVariable(JSONObject schema) {
        JSONObject variable = new JSONObject();
        variable.put("technique", "sort");
        if (schema.containsKey("fields")) {
            //有分组字段
            JSONArray fields = schema.getJSONArray("fields");
            variable.put("fields", fields);
        } else {
            variable.put("fields", new ArrayList<>());
        }
        JSONArray statistic = new JSONArray();

        JSONArray sort = schema.getJSONArray("sort");
        sort.forEach(item -> {
            JSONObject sortItem = (JSONObject) item;
            JSONObject sortField = new JSONObject();

            List<String> statisticalFields = new ArrayList<>();
            statisticalFields.add(sortItem.getJSONObject("dataObject").getString("content"));
            sortField.put("statisticalFields", statisticalFields);
            sortField.put("type", sortItem.getString("order"));
            sortField.put("statisticalMethod", "sort");
            sortField.put("mode", schema.getOrDefault("mode", TransConstant.GROUP_MODE_NORMAL));
            sortField.put("sortName", schema.getString("sortName"));
            statistic.add(sortField);
        });
        variable.put("statistics", statistic);
        return variable;
    }
}
