package com.digiwin.athena.executionengine.service.facade.mapping.test;

import com.alibaba.fastjson.JSON;

import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: fenglei
 * @date:
 */
public class CaseModule {
    public String caseName;
    public Object response;
    public String reqActionId;
    public String reqActionType;
    public String rspActionId;
    public boolean isForeach;
    public String paramPath;
    public Object testRes;
    public String fixedPath;

    public static final String MAP = "map";

    public CaseModule(String caseName, String json, String isMap, String reqActionId, String rspActionId, boolean isForeach) {
        this.caseName = caseName;
        setResponse(json, isMap);
        setReqActionId(reqActionId);
        setRspActionId(rspActionId);
        setIsForeach(isForeach);
        paramPath = "";
    }

    public CaseModule(String caseName, String json, String isMap, String reqActionId, String rspActionId, String reqActionType, boolean isForeach) {
        this.caseName = caseName;
        setResponse(json, isMap);
        setReqActionId(reqActionId);
        setRspActionId(rspActionId);
        setIsForeach(isForeach);
        setReqActionType(reqActionType);
        paramPath = "";
    }

    public void setResponse(String json, String isMap) {
        if (MAP.equals(isMap)) {
            this.response = JSON.parseObject(json, Map.class);
        }
        else {
            this.response = JSON.parseObject(json, List.class);
        }
    }

    public void setCaseName(String caseName){
        this.caseName = caseName;
    }

    public void setReqActionId(String reqActionId) {
        this.reqActionId = reqActionId;
    }

    public void setIsForeach(boolean isForeach) {
        this.isForeach = isForeach;
    }

    public void setReqActionType(String reqActionType) {
        this.reqActionType = reqActionType;
    }
    public void setRspActionId(String rspActionId) {
        this.rspActionId = rspActionId;
    }

    public void setParamPath(String paramPath){
        this.paramPath = paramPath;
    }

    public void setFixedPath(String fixedPath){
        this.fixedPath = fixedPath;
    }

    public void setTestRes(Object testRes){
        this.testRes = testRes;
    }
}
