/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.core.config;

import com.digiwin.athena.executionengine.core.property.RabbitProperty;
import java.nio.charset.StandardCharsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.AcknowledgeMode;
import org.springframework.amqp.core.Address;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.rabbit.annotation.EnableRabbit;
import org.springframework.amqp.rabbit.config.SimpleRabbitListenerContainerFactory;
import org.springframework.amqp.rabbit.connection.CachingConnectionFactory;
import org.springframework.amqp.rabbit.connection.ConnectionFactory;
import org.springframework.amqp.rabbit.core.RabbitAdmin;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.amqp.support.SendRetryContextAccessor;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.amqp.support.converter.MessageConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.retry.RetryContext;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.support.RetryTemplate;

@Configuration
@EnableAspectJAutoProxy(proxyTargetClass=true)
@EnableRabbit
public class EngineRabbitConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(EngineRabbitConfig.class);
    @Autowired
    @Qualifier(value="engineRabbitProperty")
    private RabbitProperty property;

    @Bean(value={"engineConnectionFactory"})
    public ConnectionFactory connectionFactory() {
        CachingConnectionFactory connectionFactory = new CachingConnectionFactory();
        connectionFactory.setHost(this.property.getHost());
        connectionFactory.setPort(this.property.getPort());
        connectionFactory.setUsername(this.property.getUsername());
        connectionFactory.setPassword(this.property.getPassword());
        connectionFactory.setVirtualHost(this.property.getVirtualHost());
        return connectionFactory;
    }

    @Bean(value={"engineRabbitTemplate"})
    public RabbitTemplate rabbitTemplate(@Qualifier(value="engineConnectionFactory") ConnectionFactory rabbitConnectionFactory) {
        RabbitTemplate rabbitTemplate = new RabbitTemplate(rabbitConnectionFactory);
        rabbitTemplate.setMessageConverter((MessageConverter)new Jackson2JsonMessageConverter());
        return rabbitTemplate;
    }

    @Bean(value={"engineAmqpAdmin"})
    public RabbitAdmin amqpAdmin() {
        return new RabbitAdmin(this.connectionFactory());
    }

    @Bean(value={"engineRabbitListenerContainerFactory"})
    public SimpleRabbitListenerContainerFactory rabbitListenerContainerFactory(@Qualifier(value="engineConnectionFactory") ConnectionFactory connectionFactory) {
        SimpleRabbitListenerContainerFactory factory = new SimpleRabbitListenerContainerFactory();
        factory.setConnectionFactory(connectionFactory);
        factory.setAcknowledgeMode(AcknowledgeMode.MANUAL);
        factory.setConcurrentConsumers(Integer.valueOf(this.property.getSimpleConcurrency()));
        factory.setMaxConcurrentConsumers(Integer.valueOf(this.property.getSimpleMaxConcurrency()));
        factory.setPrefetchCount(Integer.valueOf(this.property.getSimplePrefetch()));
        RetryTemplate retryTemplate = new RetryTemplate();
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setMultiplier((double)this.property.getSimpleMultiplier());
        backOffPolicy.setInitialInterval((long)this.property.getSimpleInitialInterval());
        backOffPolicy.setMaxInterval((long)this.property.getSimpleMaxInterval());
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        factory.setRetryTemplate(retryTemplate);
        factory.setReplyRecoveryCallback(ctx -> {
            Message failed = SendRetryContextAccessor.getMessage((RetryContext)ctx);
            Address replyTo = SendRetryContextAccessor.getAddress((RetryContext)ctx);
            Throwable t = ctx.getLastThrowable();
            StringBuilder message = new StringBuilder("\u6d88\u606f\u4e3a\uff1a");
            message.append(new String(failed.getBody(), StandardCharsets.UTF_8));
            message.append(", \u54cd\u5e94\u56de\u7ed9exchangeName\uff1a");
            message.append(replyTo.getExchangeName());
            message.append(", routingKey\uff1a");
            message.append(replyTo.getRoutingKey());
            message.append(" \u7684\u76f8\u5173\u64cd\u4f5c\u91cd\u8bd5\u540e\u8fd8\u662f\u5931\u8d25\uff01\u8bf7\u6ce8\u610f\uff01");
            LOGGER.error(message.toString(), t);
            return null;
        });
        return factory;
    }
}

