/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.service.facade.analyzer.IDataValueExtractor;
import java.util.ArrayList;
import org.springframework.stereotype.Service;

@Service
public class DataValueExtractor
implements IDataValueExtractor {
    @Override
    public Object extract(String key, String operator, Object rightData) {
        if ("in".equals(operator) || "nin".equals(operator)) {
            return this.handleCollectionCase(key, rightData);
        }
        return this.handleSingleValueCase(key, rightData);
    }

    private String handleCollectionCase(String key, Object rightData) {
        ArrayList<String> values = new ArrayList<String>();
        if (rightData instanceof JSONArray) {
            ((JSONArray)rightData).forEach(item -> values.add(this.extractValueFromItem(key, item)));
        } else {
            values.add(this.extractValueFromItem(key, rightData));
        }
        return String.join((CharSequence)",", values);
    }

    private Object handleSingleValueCase(String key, Object rightData) {
        Object data = rightData;
        if (data instanceof JSONArray && ((JSONArray)data).size() > 0) {
            data = ((JSONArray)data).get(0);
        }
        if (data instanceof JSONObject) {
            return ((JSONObject)data).get((Object)key);
        }
        return null;
    }

    private String extractValueFromItem(String key, Object item) {
        if (item instanceof JSONObject) {
            return String.valueOf(((JSONObject)item).get((Object)key));
        }
        return String.valueOf(item);
    }
}

