package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.AgileDataErrorCodeConstant;
import com.digiwin.athena.executionengine.constant.LogConstant;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.core.aop.ActionMock;
import com.digiwin.athena.executionengine.core.aop.Debug;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.CustomException;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.service.client.IIAMClient;
import com.digiwin.athena.executionengine.service.srp.ITransSrp;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import com.digiwin.athena.executionengine.util.JsonUtil;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.executionengine.util.PlatformServiceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description:
 * @author: fenglei
 * @date: 2023/11/16
 */

@Service("MicroTransAction")
public class MicroTransAction extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MicroTransAction.class);

    private IIAMClient iamClient;

    @Autowired
    public void setIAMClient(IIAMClient iamClient) {
        this.iamClient = iamClient;
    }

    @ActionMock
    @Debug
    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
            ServiceResult serviceResult = new ServiceResult(false);
            //LOGGER.info("开始执行MicroTrans处理:{}", JSON.toJSONString(reqMap));
            if (reqMap == null) {
                LOGGER.warn("执行MicroTrans处理入参为空");
                return serviceResult;
            }

        long t1 = System.currentTimeMillis();
        TransDataManger transDataManger = new TransDataManger(actionParam.getMicroTrans(), reqMap, context.getTenantId(), context.getEocMap(), context.getToken());
        TransEngine transEngine = ContextUtils.getBean(TransEngine.class);

        try {
            //取用户信息，如果存在系统搞业务变量会用到
            JSONObject result = iamClient.getUserInfoByToken(transDataManger.getToken(), false);
            if (result != null) {
                transDataManger.setLoginUserName(result.getString("name"));
                transDataManger.setUserId(result.getString("email"));
            }
            serviceResult.setData(transEngine.runEngine(transDataManger));
            LogUtils.buildAgileLog(LogConstant.AGILE_CODE_EXECUTE_MICTRANS_ACTION, LogUtils.SUCCESS, "actionId:" + actionParam.getActionId(), "", "");

        } catch (Exception e) {
            serviceResult.setSuccess(false);
            context.setExecuteStatus(false);
            LogUtils.buildAgileLog(LogConstant.AGILE_CODE_EXECUTE_MICTRANS_ACTION, AgileDataErrorCodeConstant.EXECUTE_MICTRANS_ACTION_ERROR, "actionId:" + actionParam.getActionId(), "MICTRANS执行失败,失败原因：【" + e.getMessage() + "】", "请联系系统管理员");

        }
        LOGGER.info(String.format("micTrans：%s，执行耗时:%s ms", actionParam.getActionId(), (System.currentTimeMillis() - t1)));

        serviceResult.setSuccess(true);
        context.setExecuteStatus(true);
        //LOGGER.info("MicroTrans执行返回结果:{}", JSON.toJSONString(serviceResult.getData()));
        return serviceResult.getData();
    }
}
