package com.digiwin.athena.executionengine.service.client;

import com.alibaba.fastjson.JSONObject;

import java.util.List;
import java.util.Set;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/05/05
 */
public interface IThemeMapClient {
    /**
     * 获取行动逻辑图谱
     *
     * @param actionId
     * @param tenantId
     * @param paramKeys
     * @param sysParamKeys
     * @param token
     * @return
     */
    JSONObject getExecutionRule(String actionId, String tenantId, Set<String> paramKeys, Set<String> sysParamKeys, String token);

    JSONObject getUIMetaData(String actionId, String token, String tenantId, String locale);

    /**
     * 批量查询行动逻辑图谱
     *
     * @param tenantId
     * @param actionIds
     * @param token
     * @return
     */
    JSONObject getExecutionRules(String tenantId, List<String> actionIds, String token);

    /**
     * 获取变量接口
     *
     * @param tenantId
     * @param variableIds
     * @param token
     * @return
     */
    JSONObject querySmartDataVariable(String tenantId, List<String> variableIds, String token);


    /**
     * 获取原子指标下的bmd节点信息
     *
     * @param metricIds
     * @return
     */
    JSONObject queryMetricQuerySchema(Set<String> metricIds);
}