package com.digiwin.athena.executionengine.service.facade.router;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.input.InputParamModule;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/5/5
 */
public interface IDataAnalyzerRouterFacade {

    /**
     * 初始化执行引擎上下文
     *
     * @param inputParamModule
     * @param token
     * @return
     */
    ExecuteContext initExecuteContext(InputParamModule inputParamModule, String token);

    /**
     * 分析入參
     *
     * @param context
     */
    void analyseInputParam(ExecuteContext context);

    /**
     * 分析
     *
     * @param context
     * @param executionRule
     */
    void analyseThemeMapData(ExecuteContext context, JSONObject executionRule);

}
