package com.digiwin.athena.executionengine.service.facade.transform;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.google.common.collect.Maps;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/8/12
 */
@Service
public class AggregatorImpl implements IAggregator {
    @Override
    public void processAggregation(JSONObject json, List<Map<String, Object>> polyData, int level, int maxDepth, Map<String, MetaNode> nodeMap) {
        Polymerization polymerization = genPolymerizationInfo(level, nodeMap);
        if (level >= maxDepth || StringUtils.isEmpty(polymerization.getNewField())) {
            json.put("temp_" + level, polyData);
            return;
        }

        List<Map<String, Object>> result = aggregatedData(polymerization, polyData, nodeMap);
        json.put("temp_" + level, result);

        if (CollectionUtils.isEmpty(result)) {
            return;
        }

        for (Map<String, Object> stringObjectMap : result) {
            Object data = stringObjectMap.get(polymerization.getNewField());
            List<Map<String, Object>> nextPolyData = null;
            if (data instanceof List) {
                nextPolyData = (List<Map<String, Object>>) stringObjectMap.get(polymerization.getNewField());
                processAggregation(json, nextPolyData, level + 1, maxDepth, nodeMap);
                stringObjectMap.put(polymerization.getNewField(), json.get("temp_" + (level + 1)));
            } else if (data instanceof Map) {
                processAggregationMap(json, (Map<String, Object>) data, level + 1, maxDepth, nodeMap);
            }
        }
        if (level == 1) {
            json.put("result", result);
        }
    }

    private void processAggregationMap(JSONObject json, Map<String, Object> map, int level, int maxDepth, Map<String, MetaNode> nodeMap) {
        Polymerization polymerization = genPolymerizationInfo(level, nodeMap);
        if (level >= maxDepth || StringUtils.isEmpty(polymerization.getNewField())) {
            return;
        }

        if (nodeMap.get(polymerization.getNewField()) != null && nodeMap.get(polymerization.getNewField()).isArray()) {
            //先聚合
            aggregatedMapData(polymerization, map, nodeMap);
            List<Map<String, Object>> polyData = (List<Map<String, Object>>) map.get(polymerization.getNewField());

            if (CollectionUtils.isEmpty(polyData)) {
                return;
            }

            for (Map<String, Object> stringObjectMap : polyData) {
                processAggregationMap(json, stringObjectMap, level + 1, maxDepth, nodeMap);
            }
        } else {
            processAggregationMap(json, map, level + 1, maxDepth, nodeMap);
        }
    }

    private void aggregatedMapData(Polymerization polymerization, Map<String, Object> map, Map<String, MetaNode> nodeMap) {
        Map<String, Object> rowMap = new HashMap<>();
        // key为需要分组的key直接放到新的记录 否则都添加到新的节点中
        Map<String, Object> elementMap = new HashMap<>();

        List<Object> rowElementList = new ArrayList<>();
        List<String> polymerizationFields = polymerization.getPolymerizationFields();
        for (Map.Entry<String, Object> entryData : map.entrySet()) {
            // 用来归并剩下字段值的集合
            if (polymerizationFields.contains(entryData.getKey())) {
                String key = truncateKey(entryData.getKey());
                rowMap.put(key, entryData.getValue());
            } else {
                String key = truncateKey(entryData.getKey());
                elementMap.put(key, entryData.getValue());
                rowElementList.add(elementMap);
            }
            rowMap.put(polymerization.getNewField(), rowElementList);
        }

        map.clear();
        map.putAll(rowMap);
    }


    @Override
    public Map<String, MetaNode> analyzeAPIMetaData(List<ParamElement> paramElements) {
        Map<String, MetaNode> nodeMap = new HashMap<>();
        analyzeParameters(nodeMap, 1, "", paramElements);
        return nodeMap;
    }

    private void analyzeParameters(Map<String, MetaNode> nodeMap, int depth, String parentPath, List<ParamElement> paramElements) {
        for (ParamElement paramElement : paramElements) {
            String currentPath = parentPath.isEmpty() ? paramElement.getParamName() : parentPath + "." + paramElement.getParamName();
            boolean isLeaf = CollectionUtils.isEmpty(paramElement.getChildElements());
            nodeMap.put(paramElement.getParamName(),
                    new MetaNode(paramElement.getParamName(), depth,
                            currentPath, paramElement.getValueType().getType(), isLeaf, paramElement.getArray()));

            if (!isLeaf) {
                analyzeParameters(nodeMap, depth + 1, currentPath, paramElement.getChildElements());
            }
        }
    }

    private Polymerization genPolymerizationInfo(int level, Map<String, MetaNode> nodeMap) {
        List<MetaNode> collect = nodeMap.values().stream()
                .filter(n -> n.getDepth() == level)
                .collect(Collectors.toList());
        List<String> fields = new ArrayList<>();
        String newField = null;
        for (MetaNode node : collect) {
            if (node.isLeaf()) {
                fields.add(node.getName());
            } else {
                newField = node.getName();
            }
        }
        return new Polymerization(fields, newField);
    }


    private List<Map<String, Object>> aggregatedData(Polymerization polymerization
            , List<Map<String, Object>> dataList, Map<String, MetaNode> nodeMap) {

        List<String> polymerizationFields = polymerization.getPolymerizationFields();

        // 存放每次归并处理的结果集
        List<Map<String, Object>> rootList = new ArrayList<>();
        //聚合字段判断是否是对象 直接处理
        if (nodeMap.get(polymerization.getNewField()) != null && !nodeMap.get(polymerization.getNewField()).isArray()) {
            for (Map<String, Object> data : dataList) {
                Map<String, Object> rowMap = new HashMap<>();
                // key为需要分组的key直接放到新的记录 否则都添加到新的节点中
                Map<String, Object> elementMap = new HashMap<>();
                for (Map.Entry<String, Object> entryData : data.entrySet()) {
                    // 用来归并剩下字段值的集合
                    if (polymerizationFields.contains(entryData.getKey())) {
                        String key = truncateKey(entryData.getKey());
                        rowMap.put(key, entryData.getValue());
                    } else {
                        String key = truncateKey(entryData.getKey());
                        elementMap.put(key, entryData.getValue());
                    }
                }
                if (MapUtils.isNotEmpty(elementMap)) {
                    rowMap.put(polymerization.getNewField(), elementMap);
                    rootList.add(rowMap);
                }

            }
            return rootList;

        }

        Map<String, List<Map<String, Object>>> groupMap = dataList.stream().collect(Collectors.groupingBy(map -> {
            StringBuilder builder = new StringBuilder();
            polymerizationFields.forEach(item -> builder.append(map.get(item)));
            return builder.toString();
        }));

        // 处理分组后的Map
        for (Map.Entry<String, List<Map<String, Object>>> entry : groupMap.entrySet()) {
            Map<String, Object> rowMap = new HashMap<>();
            List<Object> rowElementList = new ArrayList<>();
            // 遍历分组后的每条记录
            for (Map<String, Object> data : entry.getValue()) {
                // key为需要分组的key直接放到新的记录 否则都添加到新的节点中
                Map<String, Object> elementMap = new HashMap<>();
                for (Map.Entry<String, Object> entryData : data.entrySet()) {
                    // 用来归并剩下字段值的集合
                    if (polymerizationFields.contains(entryData.getKey())) {
                        String key = truncateKey(entryData.getKey());
                        rowMap.put(key, entryData.getValue());
                    } else {
                        String key = truncateKey(entryData.getKey());
                        elementMap.put(key, entryData.getValue());
                    }
                }
                if (MapUtils.isNotEmpty(elementMap)) {
                    rowElementList.add(elementMap);
                }
            }
            // 根据给定的别名 作为list节点的key
            if (CollectionUtils.isNotEmpty(rowElementList)) {
                rowMap.put(polymerization.getNewField(), rowElementList);
            }
            rootList.add(rowMap);
        }
        return rootList;
    }

    private String truncateKey(String key) {
        if (StringUtils.isBlank(key)) {
            return key;
        }
        String[] keyArray = key.split("\\#");
        return keyArray[keyArray.length - 1];
    }
}
