package com.digiwin.athena.executionengine.util;

import com.digiwin.app.service.DWServiceChainContext;
import com.digiwin.athena.executionengine.constant.MqConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.mq.ExceptionMessageDto;
import com.digiwin.athena.executionengine.model.mq.SuccessMessageDto;
import com.digiwin.athena.executionengine.mq.producer.RabbitMqProducer;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/12/15
 */
public class MqSendUtils {

    private static final Logger LOGGER = LoggerFactory.getLogger(MqSendUtils.class);

    /**
     * 发送异常消息
     *
     * @param context
     * @param exceptionMessage
     */
    public static void sendExceptionMessage(ExecuteContext context, String exceptionMessage) {
        String traceId = DWServiceChainContext.getContext().getTraceElement().getRoot().getId();
        String sessionId = DWServiceChainContext.getContext().getId();
        String parentSessionId = DWServiceChainContext.getContext().getParentId();
        String createdTime = DateUtils.getCurrentDateTime();
        LOGGER.debug("alarm");
        String pinpointId = ThreadContext.get("PtxId");
        ExceptionMessageDto exceptionMessageDto = new ExceptionMessageDto(traceId, context.getTenantId(), pinpointId, sessionId, parentSessionId, exceptionMessage, createdTime, context.getCurrentActionId());
        LOGGER.info("发送异常消息:{}", exceptionMessageDto);
        try {
            ContextUtils.getBean(RabbitMqProducer.class).sendMessage(exceptionMessageDto, MqConstant.LOG_EXCEPTION_ROUTING_KEY);
        } catch (Exception e) {
            LOGGER.error("发送异常消息失败", e);
        }
    }

    /**
     * 发送成功消息
     *
     * @param context
     * @param param
     */
    public static void sendSuccessMessage(ExecuteContext context, String actionType, Map<String, Object> param) {
        String traceId = DWServiceChainContext.getContext().getTraceElement().getRoot().getId();
        int state = context.isExecuteStatus() ? 1 : 0;
        List<Map<String, Object>> processEntities = new ArrayList<>();
        processEntities.add(param);
        String createdTime = DateUtils.getCurrentDateTime();
        SuccessMessageDto successMessageDto = new SuccessMessageDto(traceId, context.getTenantId(), state, actionType, processEntities, createdTime);
        try {
            ContextUtils.getBean(RabbitMqProducer.class).sendMessage(successMessageDto, MqConstant.LOG_SUCCESS_ROUTING_KEY);
        } catch (Exception e) {
            LOGGER.error("发送成功消息失败", e);
        }
    }
}
