/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.core.aop;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.aop.Debug;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.runinfo.ActionExecutionDto;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

@Aspect
@Component(value="engineDebugAspect")
public class DebugAspect {
    @Pointcut(value="@annotation(com.digiwin.athena.executionengine.core.aop.Debug)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        Object data;
        MethodSignature methodSignature = (MethodSignature)joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        Debug debug = method.getAnnotation(Debug.class);
        if (debug == null) {
            return joinPoint.proceed();
        }
        Object[] args = joinPoint.getArgs();
        ExecuteContext context = (ExecuteContext)args[0];
        if (!context.isDebug()) {
            return joinPoint.proceed();
        }
        ActionParam actionParam = (ActionParam)args[2];
        JSONObject metaObj = actionParam.getMetaObj();
        String actionTypeDescription = metaObj.getString("actionTypeDescription");
        String actionName = metaObj.getString("actionName");
        String actionId = actionParam.getActionId();
        int recordCnt = 0;
        Object proceed = joinPoint.proceed();
        if (proceed != null && proceed instanceof List) {
            recordCnt = ((List)proceed).size();
        } else if (proceed instanceof Map && (data = ((Map)proceed).get("data")) != null && data instanceof List) {
            recordCnt = ((List)data).size();
        }
        ActionExecutionDto actionExecutionDto = new ActionExecutionDto(actionId, recordCnt, actionTypeDescription, actionName);
        actionExecutionDto.setQuery(context.getQuerySqlMap().get(actionId));
        context.getRunInfo().getActionExecutionDtos().add(actionExecutionDto);
        return proceed;
    }
}

