/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.analyzer.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.SolutionStepContext;
import com.digiwin.athena.executionengine.model.input.SolutinStep.SolutionStep;
import com.digiwin.athena.executionengine.service.facade.analyzer.ISolutionStepAnalyzer;
import com.digiwin.athena.executionengine.service.facade.convert.trans.ITransDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.execution.impl.SolutionStepExecutionFacade;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.trans.TransEngine;
import com.digiwin.athena.executionengine.util.ContextUtils;
import java.util.HashMap;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="limitStep")
public class LimitSolutionStepAnalyzer
implements ISolutionStepAnalyzer {
    private static final Logger LOGGER = LoggerFactory.getLogger(LimitSolutionStepAnalyzer.class);
    private ITransDefinitionConvertor transDefinitionConvertor;

    @Autowired
    public void setITransDefinitionConvertor(ITransDefinitionConvertor transDefinitionConvertor) {
        this.transDefinitionConvertor = transDefinitionConvertor;
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, ISolutionStepAnalyzer nextStep, SolutionStepContext context) {
    }

    @Override
    public void executeStep(SolutionStep solutionStep, int stepIndex, SolutionStepContext context) {
        String dataKey = stepIndex + "-" + solutionStep.getAlias();
        Object sortData = SolutionStepExecutionFacade.getTransDataMap() != null && SolutionStepExecutionFacade.getTransDataMap().containsKey(dataKey) ? SolutionStepExecutionFacade.getTransDataMap().get(dataKey) : null;
        LOGGER.info("limitStep\u5f00\u59cb\u6267\u884csortData==null:{}", (Object)(sortData == null ? "true" : "false"));
        if (sortData != null) {
            HashMap<String, Object> dataMap = new HashMap<String, Object>();
            dataMap.put(dataKey, sortData);
            JSONObject criteriaDefinition = new JSONObject();
            criteriaDefinition.put("technique", (Object)"limit");
            criteriaDefinition.put("schema", (Object)JSONObject.parseObject((String)JSONObject.toJSONString((Object)solutionStep.getLimit())));
            JSONObject jsonObject = this.transDefinitionConvertor.convert(criteriaDefinition);
            LOGGER.info("limitStep\u6267\u884ctrans\u5165\u53c2:{}", (Object)JSONObject.toJSONString((Object)jsonObject));
            TransDataManger transDataManger = new TransDataManger(jsonObject, dataMap, context.getTenantId(), context.getEocMap(), context.getToken());
            TransEngine transEngine = ContextUtils.getBean(TransEngine.class, new Object[0]);
            Object resultData = transEngine.runEngine(transDataManger);
            SolutionStepExecutionFacade.getTransDataMap().put(dataKey, resultData);
            if (CollectionUtils.isNotEmpty(solutionStep.getUnion())) {
                ISolutionStepAnalyzer unionStep = (ISolutionStepAnalyzer)ContextUtils.getBean("unionStep", new Object[0]);
                unionStep.executeStep(solutionStep, stepIndex, context);
            } else {
                SolutionStepExecutionFacade.getTransDataMap().put(solutionStep.getAlias(), resultData);
                SolutionStepExecutionFacade.getTransDataMap().remove(dataKey);
            }
        }
    }
}

