package com.digiwin.athena.executionengine.component.action;

import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.MetaDataConstant;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.model.ServiceResult;
import com.digiwin.athena.executionengine.service.srp.ITransSrp;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.util.ContextUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

import java.util.Map;

/**
 * @description:
 * @author: xijj
 * @date: 2020/7/20 18:04
 */

@Service("TransAction")
public class TransAction extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TransAction.class);


    @Override
    public Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        String ruleId = actionParam.getMetaObj().getString(MetaDataConstant.ACTION_TRANS_RULE_ID);
        try {
            ServiceResult serviceResult = ContextUtils.getBean(ITransSrp.class).runTransByTransAction(context, ruleId, reqMap);
            context.setExecuteStatus(serviceResult.getSuccess());
            return serviceResult.getData();
        } catch (Exception e) {
            context.setExecuteStatus(false);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0007");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.X);
            context.setExecuteErrorMessage(executeErrorMessage);
            LOGGER.error("执行引调用trans异常", e);
            throw e;
        }
    }
}
