package com.digiwin.athena.executionengine.core.aop;

import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.springframework.stereotype.Component;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.Optional;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/4/15
 */
@Aspect
@Component("engineActionMockAspect")
public class ActionMockAspect {
    @Pointcut("@annotation(com.digiwin.athena.executionengine.core.aop.ActionMock)")
    public void pointcut() {
    }


    @Around("pointcut()")
    public Object around(ProceedingJoinPoint joinPoint) throws Throwable {
        MethodSignature methodSignature = (MethodSignature) joinPoint.getSignature();
        Method method = methodSignature.getMethod();
        ActionMock actionMock = method.getAnnotation(ActionMock.class);
        Object[] args = joinPoint.getArgs();
        ExecuteContext context = (ExecuteContext) args[0];
        ActionParam actionParam = (ActionParam) args[2];

        Object mockData = Optional.ofNullable(context.getMockData()).map(m ->
                m.get(actionParam.getActionId())).orElse(null);

        if (actionMock == null || mockData == null) {
            //没有标注mock注解，直接执行
            return joinPoint.proceed();
        }
        return mockData;
    }
}
