package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.jayway.jsonpath.Configuration;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Option;
import com.jayway.jsonpath.ReadContext;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;

/**
 * @description: json 解析器工具类
 * @author: renwm
 * @date: 2020/6/16 13:43
 */
public class JsonResolverUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(JsonResolverUtils.class);

    /**
     * 获取JSON path的value
     *
     * @param obj
     * @param path
     * @return
     */
    public static Object getJsonPathVal(Object obj, String path) {
        if (null == obj || StringUtils.isBlank(path)) {
            return null;
        }

        Configuration conf = Configuration.defaultConfiguration();
        try {
            Configuration readConf = conf.addOptions(Option.DEFAULT_PATH_LEAF_TO_NULL);
            ReadContext ctx = JsonPath.using(readConf).parse(JSON.toJSONString(obj));
            return ctx.read(path);
        } catch (Exception e) {
            LOGGER.error("解析json:{}中的路径{}异常:{}", obj, path, e);
        }
        return null;
    }

    /**
     * 获取数据的ReadContext对象
     *
     * @param obj
     * @param path
     * @return
     */
    public static ReadContext getReadContext(Object obj, String path) {
        if (null == obj || StringUtils.isBlank(path)) {
            return null;
        }

        Configuration conf = Configuration.defaultConfiguration();
        try {
            Configuration readConf = conf.addOptions(Option.DEFAULT_PATH_LEAF_TO_NULL);
            ReadContext ctx = JsonPath.using(readConf).parse(JSON.toJSONString(obj));
            return ctx;
        } catch (Exception e) {
            LOGGER.error("解析json:{}中的路径{}异常:{}", obj, path, e);
        }
        return null;
    }

    /**
     * 通过ReadContext和jsonpath获取数据
     *
     * @param ctx
     * @param path
     * @return
     */
    public static Object getJsonPathVal(ReadContext ctx, String path) {
        return ctx.read(path);
    }

    public static String toJsonString(Object obj) {
        return JSON.toJSONString(obj, SerializerFeature.WRITE_MAP_NULL_FEATURES, SerializerFeature.QuoteFieldNames);
    }
}
