/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.restful.DWRequestMethod;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.ResponseStatusException;
import com.digiwin.iam.HttpResponseModel;
import com.digiwin.iam.IAMService;
import com.digiwin.iam.ServiceModel;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="IamAction")
public class IamAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(IamAction.class);

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String url = metaObj.getString("url");
        JSONObject actionJson = actionParam.getActionJson();
        String allocateType = actionJson.getString("allocateType");
        try {
            ServiceModel iamModel = new ServiceModel();
            iamModel.setToken(context.getToken());
            iamModel.setInvokeURL(url);
            iamModel.setParams(reqMap);
            iamModel.setRequestMethod(DWRequestMethod.POST);
            HttpResponseModel responseModel = (HttpResponseModel)IAMService.invoke((ServiceModel)iamModel);
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528IAM\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{url, reqMap, responseModel.getResponseBody()});
            if (200 == responseModel.getHttpStatusCode()) {
                JSONArray jsonArray;
                context.setExecuteStatus(true);
                String result = String.format("{\"responseBody\":%s}", responseModel.getResponseBody());
                if ("RANDOM".equals(allocateType) && null != (jsonArray = JSON.parseArray((String)responseModel.getResponseBody())) && jsonArray.size() > 1) {
                    result = JSON.toJSONString((Object)jsonArray.get(ThreadLocalRandom.current().nextInt(jsonArray.size() - 1)));
                }
                return JSON.parseObject((String)result);
            }
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u89e6\u53d1IAM[{}]\u5f02\u5e38:{}", (Object)url, (Object)e);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0002");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.IAM);
            context.setExecuteErrorMessage(executeErrorMessage);
            context.setExecuteStatus(false);
            throw new ResponseStatusException(ErrorCodeEnum.CALL_IAM_EXCEPTION.getCode(), ErrorCodeEnum.CALL_IAM_EXCEPTION.getMessage(), e);
        }
        return null;
    }
}

