/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.dto.LogDataDto;
import com.digiwin.athena.executionengine.dto.LogDto;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.MqSendUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="ServiceComposerAction")
public class ServiceComposerAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(ServiceComposerAction.class);
    private static final String START_SERVICE_COMPOSER = "startServiceComposer";

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String serviceComposerId = metaObj.getString("serviceComposerId");
        boolean asyncComplete = metaObj.getBoolean("asyncComplete");
        if (!asyncComplete) {
            LOGGER.info("header\u4e2dmonitorProcessType:{}", (Object)context.getMonitorProcessType());
            asyncComplete = START_SERVICE_COMPOSER.equalsIgnoreCase(context.getMonitorProcessType());
        }
        LOGGER.info("\u4e0a\u4e0b\u6587\u53d6\u5230\u7684locale:{}", (Object)context.getLocale());
        JSONObject actionJson = actionParam.getActionJson();
        String locale = actionJson.getString("locale");
        locale = StringUtils.isEmpty((CharSequence)context.getLocale()) ? locale : context.getLocale();
        LOGGER.info("\u53d1\u8d77\u670d\u52a1\u7f16\u6392\u6700\u7ec8\u4f7f\u7528\u7684locale:{}", (Object)locale);
        JSONObject respObj = null;
        try {
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("token", context.getToken());
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            headerMap.put("routerKey", context.getRouterKey());
            headerMap.put("locale", locale);
            headerMap.put("invokerId", "ExecutionEngine");
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("serviceComposerId", serviceComposerId);
            param.put("asyncComplete", asyncComplete);
            param.put("tenantId", context.getTenantId());
            param.put("eocMap", context.getEocMap());
            param.put("params", reqMap);
            String jsonParam = JsonResolverUtils.toJsonString(param);
            String httpRespContent = HttpClientUtils.doPost(ModuleProperty.SERVICE_COMPOSER_URL, headerMap, jsonParam);
            if (httpRespContent == null) {
                context.setExecuteStatus(false);
                LOGGER.error("\u6267\u884c\u5f15\u64ce\u8c03\u7528\u670d\u52a1\u7f16\u6392\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1anull", (Object)actionParam.getActionId(), (Object)jsonParam);
                return null;
            }
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528\u670d\u52a1\u7f16\u6392\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{actionParam.getActionId(), jsonParam, httpRespContent});
            respObj = ServiceResponseUtils.getServiceComposerResp(httpRespContent);
            if (respObj == null) {
                context.setExecuteStatus(false);
            } else {
                context.setExecuteStatus(true);
            }
            this.logTrace(respObj, true);
            MqSendUtils.sendSuccessMessage(context, "ServiceComposer", param);
            return respObj;
        }
        catch (Exception e) {
            this.logTrace(respObj, false);
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u8c03\u7528\u670d\u52a1\u7f16\u6392\u5f02\u5e38", (Throwable)e);
            context.setExecuteStatus(false);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0001");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.SERVICE_COMPOSER);
            context.setExecuteErrorMessage(executeErrorMessage);
            MqSendUtils.sendExceptionMessage(context, e.getMessage());
            throw e;
        }
    }

    private void logTrace(JSONObject respObj, boolean success) {
        String wid = Optional.ofNullable(respObj).map(item -> respObj.getString("wid")).orElse(null);
        String rid = Optional.ofNullable(respObj).map(item -> respObj.getString("rid")).orElse(null);
        StringBuilder value = new StringBuilder();
        value.append("wId=").append(wid).append("&&rId=").append(rid);
        LogDataDto logDataDto = new LogDataDto(value.toString(), "\u670d\u52a1\u7f16\u6392wid\u548crid", "link", "serviceComposer");
        String message = success ? "\u8c03\u7528\u670d\u52a1\u7f16\u6392\u6210\u529f" : "\u8c03\u7528\u670d\u52a1\u7f16\u6392\u5931\u8d25";
        LogDto logDto = new LogDto(message, Arrays.asList(logDataDto));
        if (success) {
            LOGGER.info(logDto.toString());
        } else {
            LOGGER.error(logDto.toString());
        }
    }
}

