package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.ArrayList;
import java.util.List;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2021/7/23
 */
public class MultiPathParam extends ParamBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPathParam.class);


    /**
     * 最终选择的路径
     */
    private ParamBase chosen;

    /**
     * 多路径的paramBase
     */
    private List<ParamBase> multiParamBases;

    @Override
    protected void initProperty(JSONObject paramObj) {
        JSONArray paramArray = paramObj.getJSONArray("values");
        if (CollectionUtils.isEmpty(paramArray)) {
            return;
        }
        multiParamBases = new ArrayList<>();
        for (int i = 0, len = paramArray.size(); i < len; i++) {
            JSONObject item = paramArray.getJSONObject(i);
            ParamBase paramBase = ParamFactory.createParam(item);
            if (null == paramBase) {
                continue;
            }
            //给多路径的paramBase赋值name
            paramBase.name = this.name;
            multiParamBases.add(paramBase);
        }

    }

    @Override
    protected boolean eval(ExecuteContext context) {
        for (ParamBase paramBase : multiParamBases) {
            if (doEval(paramBase, context)) {
                return true;
            }
        }
        return false;
    }

    private boolean doEval(ParamBase paramBase, ExecuteContext context) {
        try {
            if (paramBase.eval(context)) {
                chosen = paramBase;
                //将最终选择的那个paramBase的value赋值给当前multiPathParam
                this.value = paramBase.getValue();
                return true;
            }
        } catch (Exception e) {
            LOGGER.error("当前路径执行失败", e);
        }
        return false;
    }

    @Override
    public String getSrcActionId(ExecuteContext context) {
        return chosen.getSrcActionId(context);
    }

    @Override
    public Object getData(ExecuteContext context, String jsonPath) {
        return chosen.getData(context, jsonPath);
    }

    @Override
    public Object getData(ExecuteContext context, DataMappingManager dataMappingManager, String requestActionId, String paramPath) throws Exception {
        return chosen.getData(context, dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public int getDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String jsonPath) {
        return chosen.getDataSize(dataMappingManager, requestActionId, paramPath, jsonPath);
    }

    @Override
    public int getRootSize(DataMappingManager dataMappingManager, String requestActionId) {
        return chosen.getRootSize(dataMappingManager, requestActionId);
    }

    @Override
    public List<String> getCollectionPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return chosen.getCollectionPath(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public boolean isCollectionRoot(DataMappingManager dataMappingManager, String requestActionId) {
        return chosen.isCollectionRoot(dataMappingManager, requestActionId);
    }

    @Override
    public boolean isCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return chosen.isCollectionParam(dataMappingManager, requestActionId, param);
    }

    @Override
    public boolean isObjectCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return chosen.isObjectCollectionParam(dataMappingManager, requestActionId, param);
    }

    @Override
    public int countCollectionInPath(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return chosen.countCollectionInPath(dataMappingManager, requestActionId, param);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String fixedPath) {
        return chosen.getPathDataSize(dataMappingManager, requestActionId, paramPath, fixedPath);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return chosen.getPathDataSize(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public boolean pathIsExistsInData(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return chosen.pathIsExistsInData(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public void setParentPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        chosen.setParentPathPos(dataMappingManager, requestActionId, paramPath, pos);
    }

    @Override
    public void setPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        chosen.setPathPos(dataMappingManager, requestActionId, paramPath, pos);
    }

    @Override
    public String getDataJsonPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return chosen.getDataJsonPath(dataMappingManager, requestActionId, paramPath);
    }
}
