package com.digiwin.athena.executionengine.core.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceBuilder;
import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.config.GlobalConfig;
import com.baomidou.mybatisplus.extension.plugins.MybatisPlusInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.BlockAttackInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.DynamicTableNameInnerInterceptor;
import com.baomidou.mybatisplus.extension.plugins.inner.OptimisticLockerInnerInterceptor;
import com.baomidou.mybatisplus.extension.spring.MybatisSqlSessionFactoryBean;
import com.digiwin.athena.executionengine.core.holder.RecordTableNameHandler;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionTemplate;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

import javax.sql.DataSource;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;


/**
 * @author wuyang
 */
@Configuration
@MapperScan(value = "com.digiwin.athena.executionengine.repository",sqlSessionTemplateRef = "engineSqlSessionTemplate")
public class EngineMyBatisPlusConfig {

    /**
     * 需要加上日期后缀的表名
     */
    private static final String[] TABLE_NAME_ADD_MONTH = {};

    @Bean("engineDataSource")
    @ConfigurationProperties(prefix = "spring.datasource.engine")
    public DruidDataSource engineDataSource() {
        return DruidDataSourceBuilder.create().build();
    }

    @Bean(name = "engineExecutionSessionFactory")
    public SqlSessionFactory createSqlSession(@Qualifier("engineDataSource") DataSource source) throws Exception {
        MybatisSqlSessionFactoryBean factoryBean = new MybatisSqlSessionFactoryBean();
        factoryBean.setDataSource(source);
        factoryBean.setConfiguration(engineMybatisConfiguration());
        factoryBean.setGlobalConfig(globalConfig());
        factoryBean.setPlugins(engineMybatisPlusInterceptor());
        return factoryBean.getObject();
    }

    @Bean("engineMybatisConfiguration")
    public MybatisConfiguration engineMybatisConfiguration() {
        MybatisConfiguration configuration = new MybatisConfiguration();
        configuration.setMapUnderscoreToCamelCase(true);
        return configuration;
    }

    private GlobalConfig globalConfig() {
        GlobalConfig globalConfig = new GlobalConfig();
        globalConfig.setDbConfig(dbConfig());
        return globalConfig;
    }

    private GlobalConfig.DbConfig dbConfig() {
        return new GlobalConfig.DbConfig();
    }

    @Bean("engineMybatisPlusInterceptor")
    public MybatisPlusInterceptor engineMybatisPlusInterceptor() {
        MybatisPlusInterceptor interceptor = new MybatisPlusInterceptor();
        DynamicTableNameInnerInterceptor dynamicTableNameInnerInterceptor = new DynamicTableNameInnerInterceptor();
        //拦截器处理表名
        dynamicTableNameInnerInterceptor.setTableNameHandler(
                new RecordTableNameHandler(TABLE_NAME_ADD_MONTH)
        );
        interceptor.addInnerInterceptor(dynamicTableNameInnerInterceptor);
        //加上乐观锁
        interceptor.addInnerInterceptor(new OptimisticLockerInnerInterceptor());
        //防止全表更新和删除
        interceptor.addInnerInterceptor(new BlockAttackInnerInterceptor());
        return interceptor;
    }
    @Bean(name = "engineTransactionManager")
    public DataSourceTransactionManager engineTransactionManager(@Qualifier("engineDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }
    @Bean(name = "engineSqlSessionTemplate")
    public SqlSessionTemplate engineSqlSessionTemplate(@Qualifier("engineExecutionSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new SqlSessionTemplate(sqlSessionFactory);
    }
}