package com.digiwin.athena.executionengine.enumtype;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2022/9/5
 */
public enum ErrorCodeEnum {
    /**
     * 租户id或者actionId为空
     */
    TENANT_OR_ACTION_EMPTY("P.EE.100.0001", "接收参数tenantId或者actionId为空"),

    /**
     * routerKey为空
     */
    ROUTER_KEY_EMPTY("P.EE.100.0002", "接收参数routerKey为空"),

    /**
     * 行动逻辑图谱为空
     */
    METADATA_IS_EMPTY("P.EE.100.0003", "请求ThemeMap获取actionId:[%s]信息为空"),

    /**
     * 没有对应的action对象可执行
     */
    ACTION_NOT_FOUND("P.EE.100.0004", "执行引擎执行actionId:[%s],没有对应的action对象可执行,请检查行动逻辑图谱定义"),

    /**
     * 参数合并过程中检测到同层的集合size不相同
     */
    SAME_LEVER_SIZE_DIFF("P.EE.100.0005", "参数合并过程中检测到同层的集合size不相同，无法合并"),

    /**
     * foreach定义错误
     */
    IS_FOREACH_MALFORMATION("P.EE.100.0006", "action执行规则isForeach定义有误, actionId:[%s]"),
    /**
     * 必传字段没有获取到映射关系
     */
    REQUIRE_FIELD_NONE_MAPPING_RELATION("P.EE.100.0007", "必传字段没有获取到映射关系,必传字段:[%s]"),

    /**
     * 必传字段没有获取到数据
     */
    REQUIRE_FIELD_NONE_DATA("P.EE.100.0008", "必传字段没有获取到数据,必传字段:[%s]"),
    /**
     * 映射关系在源数据中找不到
     */
    MAPPING_RELATION_NOT_FOUND_IN_SOURCE_DATA("P.EE.100.0009", "映射关系在源数据中没找到:[%s]"),

    /**
     * trans 输入为空
     */
    TRANS_INPUT_IS_EMPTY("P.EE.100.0010", "执行Trans处理入参为空"),
    /**
     * ruleId 找不到对应的trans定义
     */
    TRANS_RULE_NOT_FOUND("P.EE.100.0011", "通过ruleId:[%s]未获取到TransRule"),
    /**
     * trans 版本不对
     */
    TRANS_RULE_VERSION_ERROR("P.EE.100.0012", "请切换到Trans V2版本，V1版本不再维护"),

    /**
     * trans 定义有误
     */
    TRANS_RULE_DEFINE_ERROR("P.EE.100.0013", "trans定义错误,technique:[%s]"),

    /**
     * trans 执行失败
     */
    TRANS_EXECUTE_FAIL("P.EE.100.0014", "trans执行失败"),

    /**
     * ACTION 执行失败
     */
    ACTION_EXECUTE_FAIL("P.EE.100.0015", "执行引擎执行action返回失败,actionId:[%s]"),

    /**
     * ACTION 取数超过15万限制
     */
    ACTION_PULLING_DATA_OVERFLOW("P.EE.500.0011", "本次查询依赖的基础数据超出15万条，无法完成查询，请尝试缩小查询范围重试。"),

    /**
     * HTTP 返回非200状态码0-----------
     */
    HTTP_RESPONSE_FAIL_STATUS("P.EE.200.0001", "method:[%s]请求[%s],返回状态码为:[%s]"),
    /**
     * HTTP 客户端错误
     */
    HTTP_CLIENT_EXCEPTION("P.EE.400.0001", "method:[%s]请求[%s],客户端出现异常,响应报文为:[%s]"),

    /**
     * HTTP 服务端错误
     */
    HTTP_SERVER_EXCEPTION("P.EE.500.0001", "method:[%s]请求[%s],服务端出现异常,响应报文为:[%s]"),

    /**
     * HTTP 未知错误码
     */
    HTTP_UNKNOWN_STATUS_EXCEPTION("P.EE.200.0002", "method:[%s]请求[%s],出现未知状态码异常,响应报文为:[%s]"),

    /**
     * 其他未知异常
     */
    HTTP_UNKNOWN_EXCEPTION("P.EE.200.0003", "method:[%s]请求[%s]异常"),

    /**
     * 行动逻辑图谱求取超时
     */
    QUERY_METADATA_SERVER_TIMEOUT("P.EE.504.0001", "行动逻辑图谱求取超时"),

    /**
     * 行动逻辑图谱求取服务端异常
     */
    QUERY_METADATA_SERVER_EXCEPTION("P.EE.500.0002", "行动逻辑图谱求取服务端异常"),

    /**
     * 未知异常
     */
    UNKNOWN_EXCEPTION("P.EE.500.9999", "未知异常"),

    /**
     * 调用ESP异常
     */
    CALL_ESP_EXCEPTION("P.EE.500.0003", "调用ESP异常"),

    /**
     * 调用IAM异常
     */
    CALL_IAM_EXCEPTION("P.EE.500.0004", "调用IAM异常"),

    /**
     * Formula表达式执行异常
     */
    FORMULA_EXECUTE_EXCEPTION("P.EE.500.0005", "Formula表达式执行异常");


    private String code;
    private String message;

    public String getCode() {
        return code;
    }

    public String getMessage() {
        return message;
    }

    ErrorCodeEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

}
