package com.digiwin.athena.executionengine.model.trans;

import com.digiwin.athena.executionengine.constant.TransConstant;
import com.digiwin.athena.executionengine.model.trans.components.CalculateRuleDto;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @description:
 * @author: xijj
 * @date: 2020/7/21 18:04
 */
public class StepElement<T> {

    /**
     * 通用字段，计算节点的实例名称
     */
    private String name;

    /**
     * 通用字段，计算类型
     */
    private String technique;

    /**
     * 用于过滤组件，true符合条件的数据是保留, false不符合条件的保留
     */
    private Boolean isEject;

    /**
     * discard:该记录被过滤掉(相当于过滤条件不成立) 默认配置
     * retain 该记录保留
     */
    private String nullJudge = "discard";

    public String getNullJudge() {
        return nullJudge;
    }

    public void setNullJudge(String nullJudge) {
        this.nullJudge = nullJudge;
    }

    /**
     * 是否截取key，默认截取
     */
    private boolean isTruncateKey = true;

    private String variableName;
    private String eocLevel;

    public boolean isReturnAll() {
        return returnAll;
    }

    public void setReturnAll(boolean returnAll) {
        this.returnAll = returnAll;
    }

    private boolean returnAll = false;

    public static StepElement buildSpread(String name) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_SPREAD);
        return step;
    }

    public static StepElement buildTruncateKey(String name) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_TRUNCATEKEY);
        return step;
    }

    public static StepElement buildFilter(String name, Map<String, Object> condition) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_FILTER);
        step.setCondition(condition);
        step.setIsEject(false);
        return step;
    }


    public static StepElement buildGroup(String name, Map<String, Object> condition) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_GROUP);
        step.setCondition(condition);
        return step;
    }

    public static StepElement buildChoose(String name, String type, List<String> fields) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_CHOOSE_COLUMN);
        step.setType(type);
        step.setFields(fields);
        return step;
    }

    public static StepElement buildDistinct(String name, List<String> fields) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_DISTINCT);
        step.setFields(fields);
        return step;
    }

    public static StepElement buildHaving(String name, Map<String, Object> condition) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_FILTER);
        step.setIsEject(false);
        step.setCondition(condition);
        return step;
    }

    public static StepElement buildCalculate(String name, List rule) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_CALCULATE);
        step.setRule(rule);
        return step;
    }

    public static StepElement buildCalculate(String name,
                                             String calcType, String minuend,
                                             String subtrahend, String newField,
                                             String retain) {
        StepElement step = new StepElement();
        step.setName(name);
        step.setTechnique(TransConstant.COMPONENT_TYPE_CALCULATE);
        List<NumberRangeRuleElement> rule = new ArrayList<>(1);
        NumberRangeRuleElement minusElement = new NumberRangeRuleElement();
        minusElement.setCalcType(calcType);
        minusElement.setFieldA(minuend);
        minusElement.setFieldB(subtrahend);
        minusElement.setNewField(newField);
        minusElement.setRetain(retain);
        step.setRule(rule);
        return step;
    }

    public String getEocLevel() {
        return eocLevel;
    }

    public void setEocLevel(String eocLevel) {
        this.eocLevel = eocLevel;
    }

    private List<String> fields;

    private List<Statistic> statistics;

    private List<CollectCondition> collectConditions;

    private Map<String, Object> condition;

    private String fieldA;

    private String newField;

    /**
     * 用于数据输入组件
     */
    private String path;

    /**
     * input 基于jsonpath取不到数据情况下的默认结构
     * array或object
     */
    private String nullDefaultConstruct;

    /**
     * 用于join组件
     */
    private String dataLt;

    /**
     * 用于join组件
     */
    private String dataRt;

    /**
     * 用于join组件
     */
    private List<String> leftFields;

    /**
     * 用于join组件
     */
    private List<String> rightFields;

    /**
     * 用于join组件
     */
    private List<JoinSelectElement> selectLtFields;

    /**
     * 用于join组件
     */
    private List<JoinSelectElement> selectRtFields;


    private String type;

    /**
     * 作为逻辑判断的列
     */
    private String column;

    private String defaultValue;

    /**
     * numberRange组件新增字段
     * 描述defaultValue的类型
     * 可以不填，不填时默认defaultValue为constant
     * constant：defaultValue的值为常量值
     * column：defaultValue为字段名，此时defaultValue的值应该来自该数据行该字段的值
     */
    private String defaultValueType;

    /**
     * numberRange组件新增字段
     * defaultValue的数据类型，当defaultValueType为常量值时有效
     * string：字符串
     * number：数字类型
     */
    private String defaultValueDataType;

    /**
     * 用于numberRange组件-规则
     */
    private List<NumberRangeRuleElement> rule;

    /**
     * rules通用
     */
    private List<T> rules;

    public List<T> getRules() {
        return rules;
    }

    public void setRules(List<T> rules) {
        this.rules = rules;
    }

    /**
     * 用于runtimeInfo组件-规则
     */
    private List<RuntimeInfoElement> runtimeInfoStepRule;

    public List<RuntimeInfoElement> getRuntimeInfoStepRule() {
        return runtimeInfoStepRule;
    }

    public void setRuntimeInfoStepRule(List<RuntimeInfoElement> runtimeInfoStepRule) {
        this.runtimeInfoStepRule = runtimeInfoStepRule;
    }

    public String getDefaultValue() {
        return defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getColumn() {
        return column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public List<NumberRangeRuleElement> getRule() {
        return rule;
    }

    public void setRule(List<NumberRangeRuleElement> rule) {
        this.rule = rule;
    }

    /**
     * 计算规则序列
     */
    List<CalculateRuleDto> calculateRuleDtoList;

    public List<CalculateRuleDto> getCalculateRuleDtoList() {
        return calculateRuleDtoList;
    }

    public void setCalculateRuleDtoList(List<CalculateRuleDto> calculateRuleDtoList) {
        this.calculateRuleDtoList = calculateRuleDtoList;
    }

    public List<JoinSelectElement> getSelectLtFields() {
        return selectLtFields;
    }

    public void setSelectLtFields(List<JoinSelectElement> selectLtFields) {
        this.selectLtFields = selectLtFields;
    }

    public List<JoinSelectElement> getSelectRtFields() {
        return selectRtFields;
    }

    public void setSelectRtFields(List<JoinSelectElement> selectRtFields) {
        this.selectRtFields = selectRtFields;
    }

    public List<String> getLeftFields() {
        return leftFields;
    }

    public void setLeftFields(List<String> leftFields) {
        this.leftFields = leftFields;
    }

    public List<String> getRightFields() {
        return rightFields;
    }

    public void setRightFields(List<String> rightFields) {
        this.rightFields = rightFields;
    }

    public String getDataLt() {
        return dataLt;
    }

    public void setDataLt(String dataLt) {
        this.dataLt = dataLt;
    }

    public String getDataRt() {
        return dataRt;
    }

    public void setDataRt(String dataRt) {
        this.dataRt = dataRt;
    }

    public String getPath() {
        return path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getNullDefaultConstruct() {
        return nullDefaultConstruct;
    }

    public void setNullDefaultConstruct(String nullDefaultConstruct) {
        this.nullDefaultConstruct = nullDefaultConstruct;
    }

    public String getNewField() {
        return newField;
    }

    public void setNewField(String newField) {
        this.newField = newField;
    }

    public String getFieldA() {
        return fieldA;
    }

    public void setFieldA(String fieldA) {
        this.fieldA = fieldA;
    }

    public String getTechnique() {
        return technique;
    }

    public void setTechnique(String technique) {
        this.technique = technique;
    }

    public Boolean getIsEject() {
        return isEject;
    }

    public void setIsEject(Boolean isEject) {
        this.isEject = isEject;
    }

    public String getVariableName() {
        return variableName;
    }

    public void setVariableName(String variableName) {
        this.variableName = variableName;
    }

    public List<String> getFields() {
        return fields;
    }

    public void setFields(List<String> fields) {
        this.fields = fields;
    }

    public List<Statistic> getStatistics() {
        return statistics;
    }

    public void setStatistics(List<Statistic> statistics) {
        this.statistics = statistics;
    }

    public List<CollectCondition> getCollectConditions() {
        return collectConditions;
    }

    public void setCollectConditions(List<CollectCondition> collectConditions) {
        this.collectConditions = collectConditions;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTruncateKey() {
        return isTruncateKey;
    }

    public void setTruncateKey(boolean truncateKey) {
        isTruncateKey = truncateKey;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean getEject() {
        return isEject;
    }

    public void setEject(Boolean eject) {
        isEject = eject;
    }

    public Map<String, Object> getCondition() {
        return condition;
    }

    public void setCondition(Map<String, Object> condition) {
        this.condition = condition;
    }

    public String getDefaultValueType() {
        return defaultValueType;
    }

    public void setDefaultValueType(String defaultValueType) {
        this.defaultValueType = defaultValueType;
    }

    public String getDefaultValueDataType() {
        return defaultValueDataType;
    }

    public void setDefaultValueDataType(String defaultValueDataType) {
        this.defaultValueDataType = defaultValueDataType;
    }
}
