package com.digiwin.athena.executionengine.service.facade.convert.trans;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.constant.TransConstant;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Service;

import java.util.stream.Collectors;

/**
 * @description:
 * @author: ZhangJun
 * @create: 2024/9/24
 */
@Service
public class FilterTransformer implements ICriteriaTransformer {
    @Override
    public JSONObject analysisVariable(JSONObject schema) {
        JSONObject variable = new JSONObject();
        variable.put("technique", "filter");
        variable.put("condition", transformJson(schema));
        return variable;
    }

    public static JSONObject transformJson(JSONObject originalObject) {
        JSONObject transformedObject = new JSONObject();

        transformedObject.put("logitype", originalObject.getString("logic"));
        JSONArray items = new JSONArray();
        transformedObject.put("items", items);
        transformChildren(originalObject.getJSONArray("children"), items);

        return transformedObject;
    }

    public static void transformChildren(JSONArray children, JSONArray items) {
        for (int i = 0; i < children.size(); i++) {
            JSONObject child = children.getJSONObject(i);
            JSONObject item = new JSONObject();
            item.put("logitype", child.getString("logic"));
            if (CollectionUtils.isNotEmpty(child.getJSONArray("children"))) {
                JSONArray subItems = new JSONArray();
                item.put("items", subItems);
                transformChildren(child.getJSONArray("children"), subItems);
            } else {
                String operate = child.getString("operator");
                item.put("op", operate);
                item.put("left", child.getJSONObject("left").getString("content"));
                String contentType = child.getJSONArray("right").getJSONObject(0).getJSONObject("dataObject").getString("contentType");
                item.put("right_value_type", getRightValueType(operate, child.getJSONArray("right")));
                item.put("right", getRightValue(operate, child.getJSONArray("right")));
                item.put("logitype", "single");
                if ("field".equals(contentType)) {
                    item.put("type", TransConstant.SOURCE_TYPE_COLUMN);
                } else if ("const".equals(contentType)) {
                    item.put("type", TransConstant.SOURCE_TYPE_CONSTANT);
                } else {
                    item.put("type", TransConstant.SOURCE_TYPE_CONSTANT);
                }
                item.put("left_value_type", child.getJSONObject("left").getString("contentType"));
            }
            items.add(item);
        }
    }

    private static Object getRightValueType(String operate, JSONArray right) {
        if ("in".equals(operate) || "nin".equals(operate)) {
            return TransConstant.VALUE_TYPE_COLLECTION;
        } else {
            return right.getJSONObject(0).getJSONObject("dataObject").getString("dataType");

        }
    }

    private static Object getRightValue(String operate, JSONArray right) {
        if ("in".equals(operate) || "nin".equals(operate)) {
            JSONArray rightValue = new JSONArray();
            right.forEach(o -> rightValue.add(((JSONObject) o).getJSONObject("dataObject").getString("content")));
            return rightValue;
        } else {
            return right.getJSONObject(0).getJSONObject("dataObject").getString("content");
        }
    }


}
