package com.digiwin.athena.executionengine.service.facade.schema.dynamic;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.model.input.SolutinStep.Sort;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

@Service
public class SortBuilder extends AbstractDynamicCalculateBuilder {

    /**
     * 构建动态计算schema(包装成二次计算的定义)
     *
     * @param dynamicSchema          语义动态schema
     * @param actionParam action response 元数据结构
     */
    @Override
    public JSONObject build(Object dynamicSchema,  ActionParam actionParam) {
        List<Sort> sorts = JSONArray.parseArray(JSONArray.toJSONString(dynamicSchema), Sort.class);
        JSONArray statistics = new JSONArray();
        JSONObject actionResFieldsMapping = actionParam.getStandardParameterMapping();
        for (Sort sort : sorts) {
            if (keyExists(sort.getDataObject().getContent(), actionResFieldsMapping)) {
                //加入排序
                JSONObject statistic = new JSONObject();
                statistic.put("mode", "normal");
                statistic.put("statisticalMethod", "sort");
                statistic.put("type", sort.getOrder());
                JSONArray statisticalFields = new JSONArray();
                statisticalFields.add(sort.getDataObject().getContent());
                statistic.put("statisticalFields", statisticalFields);
                statistics.add(statistic);
            }
        }
        if (!CollectionUtils.isEmpty(statistics)) {
            JSONObject recast = new JSONObject();
            recast.put("name", "sort");
            recast.put("technique", "group");
            JSONObject condition = new JSONObject();
            condition.put("fields", new JSONArray());
            condition.put("statistics", statistics);
            recast.put("condition", condition);
            return recast;
        } else {
            return null;
        }
    }
}
