package com.digiwin.athena.executionengine.trans.components;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.constant.FieldNameConstant;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.TransDataManger;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;
import org.slf4j.Logger;
import org.springframework.stereotype.Component;

import java.util.*;

@Component("mechanism")
public class MechanismStep extends TransAbstractStep {

    private static final Logger LOGGER = LoggerFactory.getLogger(MechanismStep.class);


    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    /**
     * 数据会存储在transDataManger的mechanismDataCollection中，并且通过该对象使用
     * 但是为了统一处理，在transDataManger.stepDataCollection中，也会记录引用，但是目前是不会被使用的。（2020-12-3 version 2.0）
     *
     * @return 取机制变量组件返回值结构是：List<Map<String, Object>>，但是list只会有一个元素
     * @throws Exception
     */
    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        StepElement stepElement = step.getStepElement();
        try {
            Map<String, String> header = new HashMap<>();
            header.put("Content-Type", "application/json;charset=UTF-8");
            header.put(FieldNameConstant.USER_TOKEN, getTransDataManager().getToken());
            header.put(FieldNameConstant.CAMEL_CASE_ROUTER_KEY, getTransDataManager().getTenantId());
            header.put(FieldNameConstant.SECURITY_TOKEN, (String) DWServiceContext.getContext().getRequestHeader().get(FieldNameConstant.SECURITY_TOKEN));

            Map<String, Object> param = buildRequestBody(stepElement.getVariableName(), stepElement.getEocLevel());
            LOGGER.info("执行引擎调用themeMap获取机制变量入参:{}", param);
            String httpRespContent = HttpClientUtils.doRequest("POST", ModuleProperty.THEMEMAP_ACTION_MECHANISM_NEW, header, param);
            LOGGER.info("执行引擎调用themeMap获取机制变量返回结果:{}", httpRespContent);
            JSONObject respData = ServiceResponseUtils.getThemeMapResp(httpRespContent);
            if (respData == null) {
                dealResult.setDataNullFail();
                return dealResult;
            }
            Map<String, Object> resultMap = new HashMap<>();
            resultMap.put(stepElement.getVariableName(),
                    Optional.ofNullable(respData).map(data -> data.get(stepElement.getVariableName())).orElse(null));

            //比较特殊，自己调用trans数据管理对象完成机制变量的存储。
            getTransDataManager().setMechanismData(resultMap);

            //通过返回，将引用丢给stepDataCollection记录，只是为了保持处理的一致
            dealResult.setSuccess(getCurrentData(step.getPrevStepNameList()));
            return dealResult;
        } catch (Exception e) {
            LOGGER.error("机制变量组件获取机制变量异常");
            throw e;
        }
    }

    /**
     * 构建请求体
     *
     * @param variableName
     * @param eocLevel
     * @return
     */
    private Map<String, Object> buildRequestBody(String variableName, String eocLevel) {
        TransDataManger transDataManager = getTransDataManager();
        Map<String, Object> result = new HashMap<>(2);
        Map<String, Object> queryData = new HashMap<>(8);
        queryData.put(FieldNameConstant.MECHANISM_QUERY_DATA_VARIABLE_NAME, variableName);
        queryData.put(FieldNameConstant.TENANT_ID, transDataManager.getTenantId());
        Map<String, Object> eocMap = transDataManager.getEocMap();
        // 传eoc的需要同时满足如下条件：1. eocMap不为空 2. eocLevel不为空
        if (MapUtils.isNotEmpty(eocMap) && StringUtils.isNotBlank(eocLevel)) {
            queryData.put(FieldNameConstant.MECHANISM_QUERY_DATA_EOC_MAP, eocMap);
        }
        if (MapUtils.isNotEmpty(eocMap) && MapUtils.isNotEmpty((Map) eocMap.get("operation_unit_v2"))) {
            queryData.put(FieldNameConstant.MECHANISM_QUERY_DATA_EOC_MAP, eocMap);
        }
        queryData.put(FieldNameConstant.MECHANISM_QUERY_DATA_EOC_LEVEL, eocLevel);
        result.put(FieldNameConstant.MECHANISM_QUERY_DATA, queryData);
        return result;
    }

}
