/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="AthenaAction")
public class AthenaAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(AthenaAction.class);
    private static final String DIGI_MIDDLEWARE_AUTH_USER = "digi-middleware-auth-user";
    private static final String RESPONSE_STATUS = "status";
    private static final int RESPONSE_CODE_SUCCESS = 200;

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String url = metaObj.getString("url");
        String method = metaObj.getString("method");
        String module = metaObj.getString("module");
        try {
            HashMap<String, String> header = new HashMap<String, String>();
            header.put(DIGI_MIDDLEWARE_AUTH_USER, context.getToken());
            header.put("token", context.getToken());
            header.put("Content-Type", "application/json;charset=UTF-8");
            header.put("routerKey", context.getRouterKey());
            if (context.getLocale() != null) {
                header.put("locale", context.getLocale());
            }
            reqMap.put("tenantId", context.getTenantId());
            String domainUrl = ModuleProperty.MODULE_DOMAIN_MAP.containsKey(module) ? ModuleProperty.MODULE_DOMAIN_MAP.get(module) : ModuleProperty.ATHENA_DOMAIN_URL;
            String actionUrl = domainUrl + url;
            String httpContent = HttpClientUtils.doRequest(method, actionUrl, header, reqMap);
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528ATHENA\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{url, reqMap, httpContent});
            if (StringUtils.isBlank((CharSequence)httpContent)) {
                context.setExecuteStatus(false);
                return null;
            }
            JSONObject respObj = JSON.parseObject((String)httpContent);
            if (null == respObj || 200 != respObj.getIntValue(RESPONSE_STATUS)) {
                context.setExecuteStatus(false);
                return null;
            }
            context.setExecuteStatus(true);
            return JSONObject.parseObject((String)ServiceResponseUtils.getDwServiceResponse(httpContent));
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u89e6\u53d1ATHENA[{}]\u5f02\u5e38:{}", (Object)url, (Object)e);
            context.setExecuteStatus(false);
            throw e;
        }
    }
}

