/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.action.FormulaAction;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.aop.ActionMock;
import com.digiwin.athena.executionengine.core.aop.Debug;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.ErrorLog;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.util.DateUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.executionengine.util.ReplaceUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.script.ScriptContext;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.SimpleScriptContext;
import jdk.nashorn.api.scripting.ScriptObjectMirror;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="FormulaCAction")
public class FormulaCAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormulaAction.class);
    private static final String SCRIPT_ENGINE_SHORT_NAME = "nashorn";
    private static final String SCRIPT_METHOD_TEMPLATE = "function transform(){%s} transform();";

    @Override
    @ActionMock
    @Debug
    public Object actionExecute(ExecuteContext context, Map<String, Object> exprParams, ActionParam actionParam) {
        JSONObject actionJson = actionParam.getActionJson();
        String expression = actionJson.getString("expression");
        String target = actionJson.getString("target");
        if (StringUtils.isEmpty((CharSequence)expression)) {
            LOGGER.warn("\u6267\u884c\u5f15\u64ce\u6267\u884c{} FormulaC {} \u6ca1\u6709\u5bf9\u5e94\u7684\u53c2\u6570\u8868\u8fbe\u5f0f", (Object)actionParam.getActionId(), (Object)expression);
            context.setExecuteStatus(false);
            return null;
        }
        try {
            HashMap<String, Object> returnMap = new HashMap<String, Object>();
            if (actionParam.getRequestParams().size() == exprParams.size()) {
                Object result = this.doExpression(expression, exprParams);
                returnMap.put(target, this.convert(result));
            }
            context.setExecuteStatus(true);
            LogUtils.buildAgileLog("executeFormulaCAction", LogUtils.SUCCESS, "actionId:" + actionParam.getActionId() + ",action\u5165\u53c2:" + JSONObject.toJSONString(exprParams) + "\uff0cjs\u811a\u672c:" + expression, JSONObject.toJSONString(returnMap), "");
            return returnMap;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5f15\u64ceFormula[{}]\u6267\u884c\u8868\u8fbe\u5f0f\u5f02\u5e38:{}", (Object)actionParam.getActionId(), (Object)e);
            context.setExecuteStatus(false);
            ErrorLog errorLog = new ErrorLog();
            errorLog.setErrorCode("U.EE.500.0006");
            errorLog.setErrorLocation("\u8ba1\u7b97\u8282\u70b9\u6267\u884c\u5f02\u5e38\uff0c\u8282\u70b9id:" + actionParam.getActionId());
            errorLog.setErrorDescription("javascript\u811a\u672c\u6267\u884c\u5f02\u5e38");
            errorLog.setErrorTimestamp(DateUtils.getCurrentDateTime());
            errorLog.setErrorMessage(String.format("\u5165\u53c2:%s, javascript\u811a\u672c: %s", JSONObject.toJSONString(exprParams), expression));
            errorLog.setPossibleCausesAndGuidance("\u8bf7\u68c0\u67e5\u811a\u672c\u63a5\u6536\u7684\u5165\u53c2\u53d8\u91cf\u662f\u5426\u6b63\u786e\uff0c\u4ee5\u53ca\u811a\u672c\u672c\u8eab\u662f\u5426\u6b63\u786e");
            context.setErrorLog(errorLog);
            LogUtils.buildAgileLog("executeFormulaCAction", errorLog.getErrorCode(), "actionId:" + actionParam.getActionId() + ",action\u5165\u53c2:" + JSONObject.toJSONString(exprParams) + "\uff0cjs\u811a\u672c:" + expression, "JAVASCRIPT\u811a\u672c\u6267\u884c\u62a5\u9519\uff0c\u5931\u8d25\u539f\u56e0:\u3010" + e.getMessage() + "\u3011", "\"1.\u6253\u5f00\u5e38\u7528\u7684\u6d4f\u89c8\u5668\uff0c\u6309\u4e0bF12\u952e\u6253\u5f00\u5f00\u53d1\u8005\u5de5\u5177\uff0c\u5207\u6362\u5230console\u9762\u677f\u3002\n2.\u5c06\u9700\u8981\u8c03\u8bd5\u7684\u811a\u672c\u590d\u5236\u7c98\u8d34\u5230console\u4e2d\u3002\n3.\u89c2\u5bdfconsole\u4e2d\u7684\u62a5\u9519\u4fe1\u606f\uff0c\u6839\u636e\u63d0\u793a\u4fee\u6539\u811a\u672c\u4e2d\u7684\u9519\u8bef\u3002\n4.\u591a\u6b21\u6d4b\u8bd5\u786e\u4fdd\u811a\u672c\u5728console\u4e2d\u80fd\u6b63\u786e\u8fd0\u884c\u3002\n5.\u56de\u5230\u76f8\u5173\u7684\u5e94\u7528\u6216\u7cfb\u7edf\u7684\u53d1\u5e03\u754c\u9762\uff0c\u4fee\u6539\u5bf9\u5e94\u7684\u9884\u7b97\u8282\u70b9\uff0c\u91cd\u65b0\u53d1\u5e03\u3002\"");
            throw new BusinessException(ErrorCodeEnum.FORMULA_EXECUTE_EXCEPTION.getCode(), ErrorCodeEnum.FORMULA_EXECUTE_EXCEPTION.getMessage(), e);
        }
    }

    private Object convert(Object original) {
        if (original == null) {
            return null;
        }
        if (original instanceof String || original instanceof Integer || original instanceof Long || original instanceof Boolean || original instanceof Double) {
            return original;
        }
        if (original instanceof ScriptObjectMirror) {
            ScriptObjectMirror jsOriginal = (ScriptObjectMirror)original;
            if (jsOriginal.isArray()) {
                ArrayList<Object> listResult = new ArrayList<Object>();
                Integer length = (Integer)jsOriginal.get((Object)"length");
                for (int i = 0; i < length; ++i) {
                    listResult.add(this.convert(jsOriginal.get((Object)("" + i))));
                }
                return listResult;
            }
            if (jsOriginal.isFunction()) {
                return null;
            }
            LinkedHashMap mapResult = new LinkedHashMap();
            for (Map.Entry entry : jsOriginal.entrySet()) {
                mapResult.put(entry.getKey(), this.convert(entry.getValue()));
            }
            return mapResult;
        }
        return original;
    }

    private Object doExpression(String expression, Map<String, Object> exprParams) throws Exception {
        String execScript = String.format(SCRIPT_METHOD_TEMPLATE, expression);
        ScriptEngineManager factory = new ScriptEngineManager();
        ScriptEngine engine = factory.getEngineByName(SCRIPT_ENGINE_SHORT_NAME);
        SimpleScriptContext ctx = new SimpleScriptContext();
        ctx.setBindings(engine.createBindings(), 100);
        execScript = ReplaceUtils.replace(this.convert2ValueString(exprParams), execScript);
        return engine.eval(execScript, (ScriptContext)ctx);
    }

    private Map<String, String> convert2ValueString(Map<String, Object> variables) {
        HashMap<String, String> newMap = new HashMap<String, String>();
        variables.forEach((k, v) -> {
            if (v instanceof Map) {
                Map tTmpValue = (Map)v;
                newMap.put((String)k, new JSONObject(tTmpValue).toString());
            } else if (v instanceof List) {
                List tTmpValue = (List)v;
                newMap.put((String)k, new JSONArray(tTmpValue).toString());
            } else {
                newMap.put((String)k, v + "");
            }
        });
        return newMap;
    }
}

