/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.action;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.constant.ModuleProperty;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.core.container.ExecuteErrorMessage;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.util.HttpClientUtils;
import com.digiwin.athena.executionengine.util.JsonResolverUtils;
import com.digiwin.athena.executionengine.util.MqSendUtils;
import com.digiwin.athena.executionengine.util.ServiceResponseUtils;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service(value="TaskAction")
public class TaskAction
extends ActionBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskAction.class);

    @Override
    protected Object actionExecute(ExecuteContext context, Map<String, Object> reqMap, ActionParam actionParam) {
        JSONObject metaObj = actionParam.getMetaObj();
        String processId = metaObj.getString("processId");
        String taskId = metaObj.getString("taskId");
        JSONObject actionJson = actionParam.getActionJson();
        String requesterId = actionJson.getString("requesterId");
        String subject = actionJson.getString("subject");
        String locale = actionJson.getString("locale");
        Boolean async = actionJson.getBoolean("async");
        try {
            String jsonParam;
            String httpRespContent;
            HashMap<String, String> headerMap = new HashMap<String, String>();
            headerMap.put("token", context.getToken());
            headerMap.put("Content-Type", "application/json;charset=UTF-8");
            headerMap.put("routerKey", context.getRouterKey());
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("locale", locale);
            param.put("processId", processId);
            param.put("requesterId", requesterId);
            param.put("subject", subject);
            param.put("processVariable", reqMap);
            reqMap.put("process_EOC", context.getEocMap());
            if (StringUtils.isNotBlank((CharSequence)taskId)) {
                reqMap.put("taskId", taskId);
            }
            if (async != null) {
                param.put("async", async);
            }
            if ((httpRespContent = HttpClientUtils.doPost(ModuleProperty.BPM_START_PROCESS, headerMap, jsonParam = JsonResolverUtils.toJsonString(param))) == null) {
                context.setExecuteStatus(false);
                LOGGER.error("\u6267\u884c\u5f15\u64ce\u8c03\u7528Task\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1anull", (Object)actionParam.getActionId(), (Object)jsonParam);
                return null;
            }
            LOGGER.info("\u6267\u884c\u5f15\u64ce\u8c03\u7528Task\u6267\u884c{}:{}\u8fd4\u56de\u7684\u7ed3\u679c\u4e3a\uff1a{}", new Object[]{actionParam.getActionId(), jsonParam, httpRespContent});
            JSONObject respObj = ServiceResponseUtils.getBpmResp(httpRespContent);
            if (respObj == null) {
                context.setExecuteStatus(false);
            } else {
                context.setExecuteStatus(true);
            }
            MqSendUtils.sendSuccessMessage(context, "BPM", param);
            return respObj;
        }
        catch (Exception e) {
            LOGGER.error("\u6267\u884c\u5f15\u64ce\u89e6\u53d1Task[{}]\u53d1\u8d77\u6d41\u7a0b\u8c03\u7528\u5f02\u5e38:{}", (Object)subject, (Object)e);
            context.setExecuteStatus(false);
            ExecuteErrorMessage executeErrorMessage = new ExecuteErrorMessage();
            executeErrorMessage.setErrorMsg(e.getMessage());
            executeErrorMessage.setErrorCode("P.EE.600.0005");
            executeErrorMessage.setActionTypeEnum(ActionTypeEnum.START_TASK);
            context.setExecuteErrorMessage(executeErrorMessage);
            MqSendUtils.sendExceptionMessage(context, e.getMessage());
            throw e;
        }
    }
}

