/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.component.param;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.component.param.ParamFactory;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiPathParam
extends ParamBase {
    private static final Logger LOGGER = LoggerFactory.getLogger(MultiPathParam.class);
    private ParamBase chosen;
    private List<ParamBase> multiParamBases;

    @Override
    protected void initProperty(JSONObject paramObj) {
        JSONArray paramArray = paramObj.getJSONArray("values");
        if (CollectionUtils.isEmpty((Collection)paramArray)) {
            return;
        }
        this.multiParamBases = new ArrayList<ParamBase>();
        int len = paramArray.size();
        for (int i = 0; i < len; ++i) {
            JSONObject item = paramArray.getJSONObject(i);
            ParamBase paramBase = ParamFactory.createParam(item);
            if (null == paramBase) continue;
            paramBase.name = this.name;
            this.multiParamBases.add(paramBase);
        }
    }

    @Override
    protected boolean eval(ExecuteContext context) {
        for (ParamBase paramBase : this.multiParamBases) {
            if (!this.doEval(paramBase, context)) continue;
            return true;
        }
        return false;
    }

    private boolean doEval(ParamBase paramBase, ExecuteContext context) {
        try {
            if (paramBase.eval(context)) {
                this.chosen = paramBase;
                this.value = paramBase.getValue();
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u5f53\u524d\u8def\u5f84\u6267\u884c\u5931\u8d25", (Throwable)e);
        }
        return false;
    }

    @Override
    public String getSrcActionId(ExecuteContext context) {
        return this.chosen.getSrcActionId(context);
    }

    @Override
    public Object getData(ExecuteContext context, String jsonPath) {
        return this.chosen.getData(context, jsonPath);
    }

    @Override
    public Object getData(ExecuteContext context, DataMappingManager dataMappingManager, String requestActionId, String paramPath) throws Exception {
        return this.chosen.getData(context, dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public int getDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String jsonPath) {
        return this.chosen.getDataSize(dataMappingManager, requestActionId, paramPath, jsonPath);
    }

    @Override
    public int getRootSize(DataMappingManager dataMappingManager, String requestActionId) {
        return this.chosen.getRootSize(dataMappingManager, requestActionId);
    }

    @Override
    public List<String> getCollectionPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.chosen.getCollectionPath(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public boolean isCollectionRoot(DataMappingManager dataMappingManager, String requestActionId) {
        return this.chosen.isCollectionRoot(dataMappingManager, requestActionId);
    }

    @Override
    public boolean isCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return this.chosen.isCollectionParam(dataMappingManager, requestActionId, param);
    }

    @Override
    public boolean isObjectCollectionParam(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return this.chosen.isObjectCollectionParam(dataMappingManager, requestActionId, param);
    }

    @Override
    public int countCollectionInPath(DataMappingManager dataMappingManager, String requestActionId, String param) {
        return this.chosen.countCollectionInPath(dataMappingManager, requestActionId, param);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath, String fixedPath) {
        return this.chosen.getPathDataSize(dataMappingManager, requestActionId, paramPath, fixedPath);
    }

    @Override
    public int getPathDataSize(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.chosen.getPathDataSize(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public boolean pathIsExistsInData(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.chosen.pathIsExistsInData(dataMappingManager, requestActionId, paramPath);
    }

    @Override
    public void setParentPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        this.chosen.setParentPathPos(dataMappingManager, requestActionId, paramPath, pos);
    }

    @Override
    public void setPathPos(DataMappingManager dataMappingManager, String requestActionId, String paramPath, int pos) {
        this.chosen.setPathPos(dataMappingManager, requestActionId, paramPath, pos);
    }

    @Override
    public String getDataJsonPath(DataMappingManager dataMappingManager, String requestActionId, String paramPath) {
        return this.chosen.getDataJsonPath(dataMappingManager, requestActionId, paramPath);
    }
}

