/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.convert;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.digiwin.athena.executionengine.core.container.PocContext;
import com.digiwin.athena.executionengine.model.step.IStep;
import com.digiwin.athena.executionengine.model.step.MictransStep;
import com.digiwin.athena.executionengine.service.facade.convert.IDefinitionConvertor;
import com.digiwin.athena.executionengine.service.facade.template.ITransSchemaCreator;
import com.digiwin.athena.executionengine.util.ReplaceUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="micTrans")
public class MictransConvertor
implements IDefinitionConvertor {
    private static final Logger LOGGER = LoggerFactory.getLogger(MictransConvertor.class);
    @Autowired
    private ITransSchemaCreator transSchemaCreator;

    @Override
    public void convert(IStep step, PocContext pocContext) {
        MictransStep stepInfo = (MictransStep)step;
        JSONObject microTransSchema = this.createTransSchema(stepInfo.getMicroTrans());
        pocContext.getDefine().put(stepInfo.getStep(), microTransSchema);
    }

    private JSONObject createTransSchema(JSONArray microTrans) {
        JSONObject micTrans = microTrans.getJSONObject(0);
        String template = this.transSchemaCreator.createTransSchemaByTemplate(micTrans);
        try {
            return JSONObject.parseObject((String)ReplaceUtils.replace(micTrans, template));
        }
        catch (Exception e) {
            LOGGER.error("micTrans\u5b9a\u4e49\u8f6c\u6362\u5931\u8d25,micTrans:{},template:{}", new Object[]{micTrans, template, e});
            throw e;
        }
    }
}

