/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.execution.impl;

import com.alibaba.fastjson.JSONObject;
import com.carrotsearch.sizeof.RamUsageEstimator;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.action.ActionBase;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.dto.LogDataDto;
import com.digiwin.athena.executionengine.dto.LogDto;
import com.digiwin.athena.executionengine.dto.runinfo.DebugDto;
import com.digiwin.athena.executionengine.dto.runinfo.MetricExecutionDto;
import com.digiwin.athena.executionengine.enumtype.ActionTypeEnum;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.exception.BusinessException;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.model.reporter.ErrorLogReportDto;
import com.digiwin.athena.executionengine.service.client.IThemeMapClient;
import com.digiwin.athena.executionengine.service.facade.execution.IExecutionFacade;
import com.digiwin.athena.executionengine.service.facade.execution.impl.ActionDto;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingHandler;
import com.digiwin.athena.executionengine.service.facade.mapping.data.DataMappingManager;
import com.digiwin.athena.executionengine.service.facade.mapping.data.MetaGenerator;
import com.digiwin.athena.executionengine.service.facade.reporter.IReporter;
import com.digiwin.athena.executionengine.service.facade.router.IDataAnalyzerRouterFacade;
import com.digiwin.athena.executionengine.util.ContextUtils;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import com.digiwin.athena.executionengine.util.LogUtils;
import com.digiwin.athena.executionengine.util.ThreadPoolUtils;
import com.digiwin.athena.executionengine.vo.MetricResultVo;
import com.google.common.base.Stopwatch;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.ThreadContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class ExecutionFacade
implements IExecutionFacade {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutionFacade.class);
    public static final String METRIC_ACTION_PREFIX = "METRIC_";
    private IDataAnalyzerRouterFacade dataAnalyzerRouterFacade;
    private IThemeMapClient themeMapClient;
    private IReporter reporter;

    public ExecutionFacade(IDataAnalyzerRouterFacade dataAnalysisRouterFacade, @Qualifier(value="engineThemeMapClient") IThemeMapClient themeMapClient, @Qualifier(value="engineErrorLogReporter") IReporter reporter) {
        this.dataAnalyzerRouterFacade = dataAnalysisRouterFacade;
        this.themeMapClient = themeMapClient;
        this.reporter = reporter;
    }

    @Override
    public Object execute(InputParamModule inputParam) {
        LOGGER.info(new LogDto("\u6267\u884c\u5f15\u64ce\u63a5\u6536\u8bf7\u6c42,\u5f00\u59cb\u6267\u884c").toString());
        LOGGER.info("\u6267\u884c\u5f15\u64ce\u63a5\u6536\u7684\u53c2\u6570:{} \ntoken: {} ", (Object)inputParam, (Object)DWServiceContext.getContext().getToken());
        String source = (String)DWServiceContext.getContext().getRequestHeader().get("source");
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_pulling\u5165\u53c2:%s", source, inputParam.toString()));
        }
        long startTime = System.currentTimeMillis();
        ExecuteContext context = this.prepare(inputParam);
        ActionDto actionDto = this.getRootAction(inputParam.getActionId(), context);
        if (null == actionDto.getActionBase()) {
            throw ExceptionUtils.buildBusinessException(ErrorCodeEnum.ACTION_NOT_FOUND, inputParam.getActionId());
        }
        Object obj = this.doExecuteAction(actionDto.getActionBase(), context, actionDto.getActionParam());
        long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.info("\u6267\u884c\u5f15\u64ceduringExecute action:{}\u603b\u8017\u65f6 :{}ms", (Object)inputParam.getActionId(), (Object)timeTaken);
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_pulling\u51fa\u53c2:\u4e0d\u8f93\u51fa\u6570\u636e,\u6267\u884c\u8017\u65f6:%sms", source, timeTaken));
        }
        LOGGER.info("\u6267\u884c\u5b8c\uff0c\u4e0a\u4e0b\u6587\u5927\u5c0f\u4e3a:{}M", (Object)(RamUsageEstimator.sizeOf((Object)context) / 0x100000L));
        LOGGER.info("\u6267\u884c\u5b8c\uff0c\u4e0a\u4e0b\u6587\u5927\u5c0factionResponse\u4e3a:{}M", (Object)(RamUsageEstimator.sizeOf(context.getActionResponse()) / 0x100000L));
        if (context.isDebug() && actionDto.isMetric()) {
            Map map = (Map)obj;
            map.put("runInfo", context.getRunInfo());
            return map;
        }
        return obj;
    }

    @Override
    public MetricResultVo query(InputParamModule inputParam) {
        LOGGER.info(String.format("agiledata_%s_\u63a5\u6536\u7684\u53c2\u6570:%s \nToken:%s", "executionEngine", JSONObject.toJSONString((Object)inputParam), DWServiceContext.getContext().getToken()));
        String source = (String)DWServiceContext.getContext().getRequestHeader().get("source");
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_pulling\u5165\u53c2:%s", source, inputParam.toString()));
        }
        long startTime = System.currentTimeMillis();
        ExecuteContext context = this.prepare(inputParam);
        ActionDto actionDto = this.getRootAction(inputParam.getActionId(), context);
        if (null == actionDto.getActionBase()) {
            throw ExceptionUtils.buildBusinessException(ErrorCodeEnum.ACTION_NOT_FOUND, inputParam.getActionId());
        }
        Object obj = this.doExecuteAction(actionDto.getActionBase(), context, actionDto.getActionParam());
        long timeTaken = System.currentTimeMillis() - startTime;
        LOGGER.info("\u6307\u6807\u53d6\u6570duringExecute action:{}\u603b\u8017\u65f6 :{}ms", (Object)inputParam.getActionId(), (Object)timeTaken);
        LogUtils.buildAgileLog("pulldata", LogUtils.SUCCESS, inputParam.getActionId(), "-", "-");
        if (StringUtils.isNotEmpty((CharSequence)source)) {
            LOGGER.error(String.format("agiledata_%s_pulling\u51fa\u53c2:\u4e0d\u8f93\u51fa\u6570\u636e,\u6267\u884c\u8017\u65f6:%sms", source, timeTaken));
        }
        MetricExecutionDto metricExecutionDto = context.getRunInfo().getMetricExecutionDto();
        metricExecutionDto.setMetricId(inputParam.getActionId());
        String uuid = UUID.randomUUID().toString();
        metricExecutionDto.setUuid(uuid);
        context.getRunInfo().getActionExecutionMap().put(uuid, context.getRunInfo().getActionExecutionDtos());
        DebugDto debugDto = new DebugDto(context.getRunInfo().getActionExecutionMap(), metricExecutionDto);
        LOGGER.info(String.format("agiledata_%s_\u63a5\u6536\u7684\u51fa\u53c2:%s \nToken:%s", "executionEngine", JSONObject.toJSONString((Object)obj), DWServiceContext.getContext().getToken()));
        return new MetricResultVo(obj, debugDto);
    }

    private ActionDto getRootAction(String actionId, ExecuteContext context) {
        if (actionId.startsWith(METRIC_ACTION_PREFIX)) {
            List collect = context.getActionParamMap().entrySet().stream().filter(e -> ActionTypeEnum.PULL_DATA.getType().equalsIgnoreCase(((ActionParam)e.getValue()).getActionType())).map(e -> (ActionParam)e.getValue()).collect(Collectors.toList());
            ActionBase actionBase = ContextUtils.getBean(((ActionParam)collect.get(0)).getActionName(), ActionBase.class);
            ActionDto actionDto = new ActionDto(actionBase, (ActionParam)collect.get(0));
            actionDto.setMetric(true);
            return actionDto;
        }
        ActionBase executeAction = Optional.ofNullable(context.getActionParam(actionId)).map(ap -> ContextUtils.getBean(ap.getActionName(), ActionBase.class)).orElse(null);
        return new ActionDto(executeAction, context.getActionParam(actionId));
    }

    private ExecuteContext prepare(InputParamModule inputParam) {
        if (StringUtils.isBlank((CharSequence)inputParam.getTenantId())) {
            throw new BusinessException(ErrorCodeEnum.TENANT_OR_ACTION_EMPTY.getCode(), ErrorCodeEnum.TENANT_OR_ACTION_EMPTY.getMessage());
        }
        Object routerKey = DWServiceContext.getContext().getRequestHeader().get("routerKey");
        if (routerKey == null || StringUtils.isEmpty((CharSequence)String.valueOf(routerKey))) {
            throw new BusinessException(ErrorCodeEnum.ROUTER_KEY_EMPTY.getCode(), ErrorCodeEnum.ROUTER_KEY_EMPTY.getMessage());
        }
        String token = DWServiceContext.getContext().getToken();
        if (StringUtils.isBlank((CharSequence)inputParam.getActionId())) {
            throw new BusinessException(ErrorCodeEnum.TENANT_OR_ACTION_EMPTY.getCode(), ErrorCodeEnum.TENANT_OR_ACTION_EMPTY.getMessage());
        }
        ExecuteContext context = this.dataAnalyzerRouterFacade.initExecuteContext(inputParam, token);
        context.setRouterKey((String)routerKey);
        this.dataAnalyzerRouterFacade.analyseInputParam(context);
        Stopwatch stopwatch = Stopwatch.createStarted();
        JSONObject executionRule = this.themeMapClient.getExecutionRule(inputParam.getActionId(), inputParam.getTenantId(), context.getInputParamKeys(), context.getSysParamKeys(), token);
        stopwatch.stop();
        LOGGER.info("\u8bf7\u6c42ThemeMap \u83b7\u53d6 action[{}]\u4fe1\u606f\u8017\u65f6:{}\u6beb\u79d2", (Object)inputParam.getActionId(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        stopwatch.reset().start();
        if (MapUtils.isEmpty((Map)executionRule)) {
            throw ExceptionUtils.buildBusinessException(ErrorCodeEnum.METADATA_IS_EMPTY, inputParam.getActionId());
        }
        try {
            this.dataAnalyzerRouterFacade.analyseThemeMapData(context, executionRule);
            LogUtils.buildAgileLog("analyseExecutionRule", LogUtils.SUCCESS, executionRule.toJSONString(), "", "");
        }
        catch (Exception e) {
            LogUtils.buildAgileLog("analyseExecutionRule", "P.EE.500.0012", executionRule.toJSONString(), "\u6570\u636e\u6d41\u914d\u7f6e\u89e3\u6790\u5f02\u5e38\uff0c\u53ef\u80fd\u7684\u539f\u56e0\u662f\uff1aMICTRANS\u8282\u70b9\u914d\u7f6e\u4e0e\u5bf9\u5e94\u6a21\u677f\u914d\u7f6e\u4e0d\u4e00\u81f4\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010" + e.getMessage() + "\u3011\uff1a", "\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        LOGGER.info("\u6267\u884c\u5f15\u64ce\u89e3\u6790ThemeMap action[{}]\u7ed3\u6784\u8017\u65f6:{}\u6beb\u79d2", (Object)inputParam.getActionId(), (Object)stopwatch.elapsed(TimeUnit.MILLISECONDS));
        return context;
    }

    private Object doExecuteAction(ActionBase executeAction, ExecuteContext context, ActionParam actionParam) {
        boolean executeState = executeAction.execute(context, actionParam);
        if (!executeState) {
            if (context.getErrorLog() != null) {
                this.doReportErrorLog(context);
                String source = (String)DWServiceContext.getContext().getRequestHeader().get("source");
                LOGGER.error(String.format("agiledata_%s_pulling\u51fa\u53c2:%s", source, context.getErrorLog().toString()));
                throw new BusinessException(context.getErrorLog().getErrorCode(), context.getErrorLog().getErrorMessage());
            }
            LogUtils.buildAgileLog("pulldata", ErrorCodeEnum.ACTION_EXECUTE_FAIL.getCode(), "\u6307\u6807id\uff1a" + actionParam.getActionId(), "PULLING\u53d6\u6570\u5f02\u5e38\uff0c\u5931\u8d25\u539f\u56e0\uff1a\u3010\u7a0b\u5e8f\u8fd0\u884c\u65f6\u5f02\u5e38\u3011", "\u4f9d\u636e\u4e0d\u540c\u7684\u9519\u8bef\u72b6\u51b5\u5148\u81ea\u884c\u5904\u7406\uff0c\u5982\u95ee\u9898\u4ecd\u672a\u89e3\u51b3\uff0c\u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
            LOGGER.error(new LogDto("\u6267\u884c\u5f15\u64ce\u6267\u884c\u5931\u8d25", Arrays.asList(new LogDataDto(actionParam.getActionId(), "actionId", "config", "actionId"))).toString());
            if (Objects.nonNull(context.getExecuteErrorMessage())) {
                throw new BusinessException(context.getExecuteErrorMessage().getErrorCode(), context.getExecuteErrorMessage().getErrorMsg());
            }
            throw ExceptionUtils.buildBusinessException(ErrorCodeEnum.ACTION_EXECUTE_FAIL, actionParam.getActionId());
        }
        return context.getActionResponse().get(actionParam.getActionId());
    }

    private void doReportErrorLog(ExecuteContext context) {
        CompletableFuture.runAsync(() -> {
            ErrorLogReportDto errorLogReportDto = new ErrorLogReportDto();
            errorLogReportDto.setAppCode("ExecutionEngine");
            errorLogReportDto.setAppName("ExecutionEngine");
            errorLogReportDto.setMessageId(context.getMessageId());
            errorLogReportDto.setPixBackendId(ThreadContext.get((String)"PtxId"));
            errorLogReportDto.setDescription(context.getErrorLog().getErrorDescription());
            errorLogReportDto.setContent(context.getErrorLog().getErrorMessage());
            errorLogReportDto.setExtend(context.getErrorLog().getPossibleCausesAndGuidance());
            errorLogReportDto.setToken(context.getToken());
            errorLogReportDto.setRouterKey(context.getRouterKey());
            this.reporter.report(errorLogReportDto);
        }, ThreadPoolUtils.getExecutorService());
    }

    @Override
    public Object generateMetaHandler(DataMappingManager dataMappingMgr, String actionId, String tenantId) {
        DataMappingHandler dataMappingHandler = dataMappingMgr.getDatMappingHandler("META", "ExecutionParam");
        String locale = (String)DWServiceContext.getContext().getRequestHeader().get("locale");
        if (dataMappingHandler == null) {
            LOGGER.error("\u6784\u5efa\u6570\u636e\u7684dataMap\u7ed3\u6784\u5931\u8d25");
        }
        MetaGenerator metaGenerator = new MetaGenerator(dataMappingHandler, actionId);
        JSONObject newMeta = metaGenerator.generate();
        if (StringUtils.isBlank((CharSequence)actionId)) {
            return newMeta;
        }
        JSONObject uiMeta = this.themeMapClient.getUIMetaData(actionId, DWServiceContext.getContext().getToken(), tenantId, locale);
        newMeta = metaGenerator.merge(newMeta, uiMeta);
        return newMeta;
    }

    @Override
    public Object verify(InputParamModule inputParam) {
        ExecuteContext context = this.prepare(inputParam);
        context.setRelease(false);
        ActionBase executeAction = Optional.ofNullable(context.getActionParam(inputParam.getActionId())).map(ap -> ContextUtils.getBean(ap.getActionName(), ActionBase.class)).orElse(null);
        executeAction.execute(context, context.getActionParam(inputParam.getActionId()));
        return context.getActionResponse();
    }
}

