/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.mapping.param;

import com.digiwin.athena.executionengine.component.param.InputParam;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.component.param.PullingParam;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.service.facade.mapping.param.ParamMappingUtils;
import com.digiwin.athena.executionengine.util.JsonUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstructionUtils {
    ExecuteContext context;
    List<ParamBase> actionParams;
    private static final Logger LOGGER = LoggerFactory.getLogger(ParamMappingUtils.class);

    protected ConstructionUtils(ExecuteContext context, List<ParamBase> actionParams) {
        this.context = context;
        this.actionParams = actionParams;
    }

    protected String getConcreteJsonPath(String parentConcreteCollectionPath, ParamBase parentParamBase, ParamBase paramBase, int arrayPos) {
        return this.getConcreteJsonPath(parentConcreteCollectionPath, parentParamBase, paramBase) + "[" + arrayPos + "]";
    }

    protected String getConcreteJsonPath(String parentConcreteCollectionPath, ParamBase parentParamBase, ParamBase paramBase) {
        String parentParamPath = parentParamBase.getValue();
        return this.getConcreteJsonPath(parentConcreteCollectionPath, parentParamPath, paramBase);
    }

    protected String getConcreteJsonPath(String parentConcreteCollectionPath, String parentParamPath, ParamBase paramBase) {
        String paramPath = paramBase.getValue();
        String path = paramPath.replace(parentParamPath, "");
        return parentConcreteCollectionPath + path;
    }

    protected Map<String, ParamBase> getSrcParamBase(ParamElement paramElement) {
        HashMap<String, ParamBase> paramBaseCollection = new HashMap<String, ParamBase>();
        String elementParamPath = StringUtils.substringAfter((String)paramElement.getParamPath(), (String)(paramElement.getActionId() + "."));
        for (ParamBase paramBase : this.actionParams) {
            if (!paramBase.getName().equals(elementParamPath)) continue;
            paramBaseCollection.put(this.getMultipleSourceKey(paramBase), paramBase);
        }
        return paramBaseCollection;
    }

    public String getMultipleSourceKey(ParamBase paramBase) {
        String key = paramBase.getValue() + "@@";
        if (paramBase.getClass() == InputParam.class) {
            key = key + ((InputParam)paramBase).getParamType();
        } else if (paramBase.getClass() == PullingParam.class) {
            key = key + ((PullingParam)paramBase).getSource();
        }
        return key;
    }

    protected List<String> getPathInfo(ParamBase paramBase, String actionId) {
        return paramBase.getCollectionPath(this.context.getDataMappingManager(), actionId, paramBase.getValue());
    }

    protected Map<String, List<String>> getPathInfo(Map<String, ParamBase> paramBaseList, String actionId) {
        HashMap<String, List<String>> pathInfo = new HashMap<String, List<String>>();
        for (Map.Entry<String, ParamBase> paramBaseEntry : paramBaseList.entrySet()) {
            ParamBase paramBase = paramBaseEntry.getValue();
            List<String> pathInfoList = this.getPathInfo(paramBase, actionId);
            if (pathInfo.containsKey(paramBase.getValue())) {
                LOGGER.error("getPathInfo\u6267\u884c\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u4ee3\u7801\u7684\u8c03\u7528\uff1a paramBase.name:" + paramBase.getName());
                continue;
            }
            pathInfo.put(this.getMultipleSourceKey(paramBase), pathInfoList);
        }
        return pathInfo;
    }

    protected ParamBase getRealParentParamBase(ParamBase paramBase, Map<String, ParamBase> parentParamBaseList) {
        try {
            String actionId = paramBase.getSrcActionId(this.context);
            for (Map.Entry<String, ParamBase> parentParamBaseEntry : parentParamBaseList.entrySet()) {
                ParamBase parentParam = parentParamBaseEntry.getValue();
                if (!actionId.equals(parentParam.getSrcActionId(this.context)) || !paramBase.getValue().startsWith(parentParam.getValue())) continue;
                return parentParam;
            }
        }
        catch (Exception e) {
            LOGGER.error("\u901a\u8fc7param\u6620\u5c04\u5173\u7cfb\u5206\u6790ActionId\u5931\u8d25: " + paramBase.getName(), (Throwable)e);
            return null;
        }
        return null;
    }

    protected void setParentJsonPath(ParamBase paramBase, String actionId, String srcParamBase, int pos) {
        paramBase.setParentPathPos(this.context.getDataMappingManager(), actionId, srcParamBase, pos);
    }

    protected void setJsonPath(ParamBase paramBase, String actionId, String srcParamBase, int pos) {
        paramBase.setPathPos(this.context.getDataMappingManager(), actionId, srcParamBase, pos);
    }

    protected String getJsonPath(ParamBase paramBase, String ActionId) {
        try {
            return paramBase.getDataJsonPath(this.context.getDataMappingManager(), ActionId, paramBase.getValue());
        }
        catch (Exception e) {
            System.out.println("\u62a5\u9519\u7684actionId\u662f\uff1a" + ActionId + "paramBase\u662f\uff1a" + JsonUtil.getJsonString(paramBase));
            return "";
        }
    }
}

