/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.service.facade.router.impl;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.executionengine.component.domain.ActionParam;
import com.digiwin.athena.executionengine.component.param.ParamBase;
import com.digiwin.athena.executionengine.core.container.ExecuteContext;
import com.digiwin.athena.executionengine.enumtype.ErrorCodeEnum;
import com.digiwin.athena.executionengine.model.ParamElement;
import com.digiwin.athena.executionengine.model.input.InputParamModule;
import com.digiwin.athena.executionengine.service.facade.analyzer.IAnalyzerFacade;
import com.digiwin.athena.executionengine.service.facade.router.IDataAnalyzerRouterFacade;
import com.digiwin.athena.executionengine.util.ExceptionUtils;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
public class DataAnalyzerRouterFacade
implements IDataAnalyzerRouterFacade {
    private IAnalyzerFacade inputParamAnalysis;
    private IAnalyzerFacade metaActionAnalysis;
    private IAnalyzerFacade metadataAnalysis;

    public DataAnalyzerRouterFacade(@Qualifier(value="engineInputParamAnalyzer") IAnalyzerFacade inputParamAnalysis, @Qualifier(value="engineMetaActionAnalyzer") IAnalyzerFacade metaActionAnalysis, @Qualifier(value="engineMetadataAnalyzer") IAnalyzerFacade metadataAnalysis) {
        this.inputParamAnalysis = inputParamAnalysis;
        this.metaActionAnalysis = metaActionAnalysis;
        this.metadataAnalysis = metadataAnalysis;
    }

    @Override
    public ExecuteContext initExecuteContext(InputParamModule inputParamModule, String token) {
        Map<String, Object> sysParam;
        ExecuteContext context = new ExecuteContext(inputParamModule, token);
        Object locale = DWServiceContext.getContext().getRequestHeader().get("locale");
        String monitorProcessType = (String)DWServiceContext.getContext().getRequestHeader().get("monitorProcessType");
        context.setLocale(locale != null ? String.valueOf(locale) : null);
        context.setMonitorProcessType(monitorProcessType);
        context.setSecurityToken((String)DWServiceContext.getContext().getRequestHeader().get("security-token"));
        String messageId = (String)DWServiceContext.getContext().getRequestHeader().get("messageId");
        if (StringUtils.isNotEmpty((CharSequence)messageId)) {
            context.setMessageId(Long.valueOf(messageId));
        }
        if ((sysParam = context.getInputParam().getSysParam()) != null) {
            context.setDebug(sysParam.containsKey("debug") ? (Boolean)sysParam.get("debug") : false);
        }
        context.setRootMetricId(context.getInputParam().getActionId());
        Object object = DWServiceContext.getContext().getRequestHeader().get("application");
        String application = object != null ? String.valueOf(object) : null;
        context.setApplication(application);
        Object taskTypeObj = DWServiceContext.getContext().getRequestHeader().get("taskType");
        context.setTaskType(taskTypeObj != null ? String.valueOf(taskTypeObj) : null);
        Object taskCodeObj = DWServiceContext.getContext().getRequestHeader().get("taskCode");
        context.setTaskCode(taskCodeObj != null ? String.valueOf(taskCodeObj) : null);
        return context;
    }

    @Override
    public void analyseInputParam(ExecuteContext context) {
        this.inputParamAnalysis.analyse(context, null);
    }

    @Override
    public void analyseThemeMapData(ExecuteContext context, JSONObject executionRule) {
        this.metadataAnalysis.analyse(context, executionRule);
        this.metaActionAnalysis.analyse(context, executionRule);
        Map<String, ActionParam> actionParamMap = context.getActionParamMap();
        for (Map.Entry<String, ActionParam> actionParamEntry : actionParamMap.entrySet()) {
            ActionParam actionParam = actionParamEntry.getValue();
            List<ParamBase> actionParams = actionParam.getParams();
            this.checkMapping(actionParam.getRequestParams(), this.convertToParamSet(actionParams));
        }
    }

    private Set<String> convertToParamSet(List<ParamBase> actionParams) {
        HashSet<String> paramSet = new HashSet<String>();
        for (ParamBase paramBase : actionParams) {
            paramSet.add(paramBase.getName());
        }
        return paramSet;
    }

    private void checkMapping(List<ParamElement> paramElements, Set<String> paramSet) {
        for (ParamElement paramElement : paramElements) {
            if (!paramElement.getIsRequired().booleanValue()) continue;
            String elementParamPath = StringUtils.replaceFirst((String)paramElement.getParamPath(), (String)(paramElement.getActionId() + "."), (String)"");
            boolean isHaveMapping = false;
            if (paramSet.contains(elementParamPath)) {
                isHaveMapping = true;
            }
            if (!isHaveMapping) {
                throw ExceptionUtils.buildVerificationException(ErrorCodeEnum.REQUIRE_FIELD_NONE_MAPPING_RELATION, paramElement.getParamPath());
            }
            List<ParamElement> childElements = paramElement.getChildElements();
            if (CollectionUtils.isEmpty(childElements)) continue;
            this.checkMapping(childElements, paramSet);
        }
    }
}

