/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.trans.components;

import com.digiwin.athena.executionengine.model.trans.DealResult;
import com.digiwin.athena.executionengine.model.trans.JoinSelectElement;
import com.digiwin.athena.executionengine.model.trans.StepElement;
import com.digiwin.athena.executionengine.trans.Step;
import com.digiwin.athena.executionengine.trans.TransAbstractStep;
import com.digiwin.athena.executionengine.trans.components.InputStep;
import com.digiwin.athena.executionengine.util.LogUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="join")
public class JoinStep
extends TransAbstractStep {
    private static final Logger LOGGER = LoggerFactory.getLogger(InputStep.class);

    @Override
    public boolean defineCheck(StepElement stepElement) {
        return true;
    }

    @Override
    public DealResult doDealData(Step step) {
        DealResult dealResult = new DealResult();
        StepElement stepElement = step.getStepElement();
        try {
            String dataLtName = stepElement.getDataLt();
            Object dataLt = this.getCurrentData(dataLtName);
            String dataRtName = stepElement.getDataRt();
            Object dataRt = this.getCurrentData(dataRtName);
            if (dataLt == null && "left".equals(stepElement.getType())) {
                dealResult.setSuccess(new ArrayList());
                return dealResult;
            }
            if (dataRt == null && "left".equals(stepElement.getType())) {
                dealResult.setSuccess(dataLt);
                return dealResult;
            }
            if (dataRt == null && "right".equals(stepElement.getType())) {
                dealResult.setSuccess(new ArrayList());
                return dealResult;
            }
            if (dataLt == null && "right".equals(stepElement.getType())) {
                dealResult.setSuccess(dataRt);
                return dealResult;
            }
            if (dataLt == null && "full".equals(stepElement.getType())) {
                dealResult.setSuccess(dataRt);
                return dealResult;
            }
            if (dataRt == null && "full".equals(stepElement.getType())) {
                dealResult.setSuccess(dataLt);
                return dealResult;
            }
            if (dataLt == null && "inner".equals(stepElement.getType())) {
                dealResult.setSuccess(dataRt);
                return dealResult;
            }
            if (dataRt == null && "inner".equals(stepElement.getType())) {
                dealResult.setSuccess(dataLt);
                return dealResult;
            }
            if (dataLt == null && "cross".equals(stepElement.getType())) {
                dealResult.setSuccess(dataRt);
                return dealResult;
            }
            if (dataRt == null && "cross".equals(stepElement.getType())) {
                dealResult.setSuccess(dataLt);
                return dealResult;
            }
            List leftList = (List)dataLt;
            List rightList = (List)dataRt;
            List<String> leftFields = stepElement.getLeftFields();
            List<String> rightFields = stepElement.getRightFields();
            List<JoinSelectElement> selectLtFieldList = stepElement.getSelectLtFields();
            List<JoinSelectElement> selectRtFieldList = stepElement.getSelectRtFields();
            if ("full".equals(stepElement.getType()) || "inner".equals(stepElement.getType()) || "left".equals(stepElement.getType()) || "cross".equals(stepElement.getType())) {
                selectLtFieldList = this.analyseSelectKeys(dataLtName, selectLtFieldList);
            } else {
                ArrayList<JoinSelectElement> selectFields = new ArrayList<JoinSelectElement>();
                selectRtFieldList = this.analyseSelectKeys(dataRtName, selectLtFieldList);
                if ("right".equals(stepElement.getType())) {
                    for (JoinSelectElement jse : selectLtFieldList) {
                        if (leftFields.contains(jse.getNewField())) continue;
                        selectFields.add(jse);
                    }
                    selectRtFieldList = selectFields;
                }
            }
            selectRtFieldList = "full".equals(stepElement.getType()) || "right".equals(stepElement.getType()) ? this.analyseSelectKeys(dataRtName, selectRtFieldList) : this.analyseSelectKeys(dataRtName, selectRtFieldList);
            List<Object> data = new ArrayList();
            if ("left".equals(stepElement.getType())) {
                data = this.joinData(leftList, rightList, selectLtFieldList, selectRtFieldList, leftFields, rightFields);
            } else if ("right".equals(stepElement.getType())) {
                data = this.joinData(rightList, leftList, selectRtFieldList, selectLtFieldList, rightFields, leftFields);
            } else if ("full".equals(stepElement.getType())) {
                List<Map<String, Object>> leftDatas = this.joinData(leftList, rightList, selectLtFieldList, selectRtFieldList, leftFields, rightFields);
                List<Map<String, Object>> rightDatas = this.joinData(rightList, leftList, selectRtFieldList, selectLtFieldList, rightFields, leftFields);
                leftDatas.addAll(rightDatas);
                ArrayList<HashMap<String, Object>> mergedDeduplicatedList = new ArrayList<HashMap<String, Object>>();
                HashSet<HashMap<String, Object>> set = new HashSet<HashMap<String, Object>>();
                for (Map<String, Object> map : leftDatas) {
                    HashMap<String, Object> hashMap = new HashMap<String, Object>(map);
                    if (!set.add(hashMap)) continue;
                    mergedDeduplicatedList.add(hashMap);
                }
                data = mergedDeduplicatedList;
            } else if ("inner".equals(stepElement.getType())) {
                data = this.innerJoinData(leftList, rightList, selectLtFieldList, selectRtFieldList, leftFields, rightFields);
            } else if ("cross".equals(stepElement.getType())) {
                data = this.crossJoinData(leftList, rightList, selectLtFieldList, selectRtFieldList);
            }
            LogUtils.buildAgileLog("joinData", LogUtils.SUCCESS, String.format("leftData\u6761\u6570:%s ,joinData\u6761\u6570:%s ,join\u65b9\u5f0f:%s", CollectionUtils.isEmpty((Collection)leftList) ? "null or empty" : Integer.valueOf(leftList.size()), CollectionUtils.isEmpty((Collection)rightList) ? "null or empty" : Integer.valueOf(leftList.size()), stepElement.getType()), String.format("join\u540e\u6570\u636e\u6761\u6570:%s ", CollectionUtils.isEmpty(data) ? "null or empty" : Integer.valueOf(data.size())), "1.\u68c0\u67e5\u5173\u8054\u64cd\u4f5c\u67e5\u770b\u4f7f\u7528\u7684\u5173\u8054\u8bed\u53e5\uff08\u5982JOIN\u8bed\u53e5\uff09\u53ca\u5176\u6761\u4ef6\u3002\n2.\u5bf9\u4e8e\u805a\u5408\u67e5\u8be2\uff0c\u786e\u8ba4\u7ef4\u5ea6\u5b57\u6bb5\u5df2\u5305\u542b\u5728\u5173\u8054\u6761\u4ef6\u4e2d\u3002\n3.\u5728\u6570\u636e\u5e93\u4e2d\u4f7f\u7528TRIM()\u51fd\u6570\u68c0\u67e5\u5173\u8054\u5b57\u6bb5\u662f\u5426\u542b\u7a7a\u683c\u3002\n4.\u8c03\u6574\u5173\u8054\u8bed\u53e5\uff0c\u91cd\u65b0\u8fd0\u884c\u67e5\u8be2\uff0c\u82e5\u4ecd\u4e0d\u80fd\u89e3\u51b3\uff0c\u8054\u7cfb\u5e73\u53f0\u6280\u672f\u652f\u6301\u4eba\u5458\u3002");
            dealResult.setSuccess(data);
            return dealResult;
        }
        catch (Exception e) {
            LOGGER.error("join\u7ec4\u4ef6\u51fa\u73b0\u5f02\u5e38");
            throw e;
        }
    }

    private List<JoinSelectElement> analyseSelectKeys(String stepName, List<JoinSelectElement> selectFieldList) {
        ArrayList<JoinSelectElement> selectList = new ArrayList<JoinSelectElement>();
        Object record = null;
        Object stepData = this.getTransDataManager().getStepDataCollection(stepName);
        if (stepData instanceof List && CollectionUtils.isNotEmpty((Collection)((List)stepData))) {
            record = ((ArrayList)this.getTransDataManager().getStepDataCollection(stepName)).get(0);
        } else if (stepData instanceof Map) {
            record = stepData;
        }
        if (record == null) {
            return Collections.EMPTY_LIST;
        }
        Map map = (Map)record;
        if (CollectionUtils.isEmpty(selectFieldList)) {
            map.forEach((k, v) -> {
                if (v instanceof Number) {
                    selectList.add(new JoinSelectElement((String)k, (String)k, "number"));
                } else if (v instanceof Boolean) {
                    selectList.add(new JoinSelectElement((String)k, (String)k, "boolean"));
                } else {
                    selectList.add(new JoinSelectElement((String)k, (String)k, "string"));
                }
            });
            return selectList;
        }
        for (JoinSelectElement jse : selectFieldList) {
            if (map.get(jse.getField()) instanceof Number) {
                selectList.add(new JoinSelectElement(jse.getField(), jse.getField(), "number"));
                continue;
            }
            if (map.get(jse.getField()) instanceof Boolean) {
                selectList.add(new JoinSelectElement(jse.getField(), jse.getField(), "boolean"));
                continue;
            }
            selectList.add(new JoinSelectElement(jse.getField(), jse.getField(), "string"));
        }
        return selectList;
    }

    private List<Map<String, Object>> joinData(List<Map<String, Object>> leftList, List<Map<String, Object>> rightList, List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList, List<String> leftFields, List<String> rightFields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, List<Map>> map2Index = rightList.stream().collect(Collectors.groupingBy(map -> this.buildIndexKey((Map<String, Object>)map, rightFields)));
        for (Map<String, Object> left : leftList) {
            String key = this.buildIndexKey(left, leftFields);
            List<Map> rightData = map2Index.get(key);
            if (CollectionUtils.isEmpty(rightData)) {
                this.mergeData(selectLtFieldList, selectRtFieldList, list, left, null);
                continue;
            }
            for (Map right : rightData) {
                this.mergeData(selectLtFieldList, selectRtFieldList, list, left, right);
            }
        }
        return list;
    }

    private String buildIndexKey(Map<String, Object> data, List<String> fields) {
        StringBuilder indexKey = new StringBuilder();
        for (String field : fields) {
            indexKey.append(data.get(field));
            indexKey.append("&&");
        }
        return indexKey.toString();
    }

    private boolean checkIsMatch(List<String> leftFields, List<String> rightFields, Map<String, Object> left, Map<String, Object> right) {
        boolean isMatch = true;
        for (int i = 0; i < leftFields.size(); ++i) {
            if (Objects.equals(left.get(leftFields.get(i)), right.get(rightFields.get(i)))) continue;
            isMatch = false;
            break;
        }
        return isMatch;
    }

    private void mergeData(List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList, List<Map<String, Object>> list, Map<String, Object> left, Map<String, Object> right) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (JoinSelectElement element : selectLtFieldList) {
            map.put(element.getNewField(), left.get(element.getField()));
        }
        for (JoinSelectElement element : selectRtFieldList) {
            if (right != null) {
                map.put(element.getNewField(), right.get(element.getField()));
                continue;
            }
            if (map.containsKey(element.getNewField())) continue;
            map.put(element.getNewField(), this.getJoinDefaultValue(element.getType()));
        }
        list.add(map);
    }

    private Object getJoinDefaultValue(String type) {
        switch (type) {
            case "number": {
                return 0;
            }
            case "boolean": {
                return false;
            }
        }
        return "";
    }

    private List<Map<String, Object>> innerJoinData(List<Map<String, Object>> leftList, List<Map<String, Object>> rightList, List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList, List<String> leftFields, List<String> rightFields) {
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        Map<String, List<Map>> map2Index = rightList.stream().collect(Collectors.groupingBy(map -> this.buildIndexKey((Map<String, Object>)map, rightFields)));
        for (Map<String, Object> left : leftList) {
            String key = this.buildIndexKey(left, leftFields);
            List<Map> rightData = map2Index.get(key);
            if (CollectionUtils.isEmpty(rightData)) continue;
            for (Map right : rightData) {
                this.mergeData(selectLtFieldList, selectRtFieldList, list, left, right);
            }
        }
        return list;
    }

    private List<Map<String, Object>> crossJoinData(List<Map<String, Object>> leftList, List<Map<String, Object>> rightList, List<JoinSelectElement> selectLtFieldList, List<JoinSelectElement> selectRtFieldList) {
        if (CollectionUtils.isEmpty(leftList)) {
            return rightList;
        }
        if (CollectionUtils.isEmpty(rightList)) {
            return leftList;
        }
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>();
        for (Map<String, Object> left : leftList) {
            for (Map<String, Object> right : rightList) {
                this.mergeData(selectLtFieldList, selectRtFieldList, list, left, right);
            }
        }
        return list;
    }
}

