/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.executionengine.util;

import com.alibaba.fastjson.JSONObject;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;

public class ServiceResponseUtils {
    private static final int ESP_SUCCESS_CODE = 0;

    private ServiceResponseUtils() {
    }

    public static String getDwServiceResponse(String respContent) {
        if (StringUtils.isBlank((CharSequence)respContent)) {
            return null;
        }
        JSONObject jsonObject = JSONObject.parseObject((String)respContent);
        if (200 != jsonObject.getIntValue("status")) {
            return null;
        }
        return jsonObject.getString("response");
    }

    public static JSONObject getThemeMapResp(String respContent) {
        String data = ServiceResponseUtils.getDwServiceResponse(respContent);
        if (null == data) {
            return null;
        }
        return JSONObject.parseObject((String)data);
    }

    public static JSONObject getThemeMapData(JSONObject respObj) {
        if (null == respObj) {
            return null;
        }
        JSONObject dataObj = respObj.getJSONObject("data");
        return ServiceResponseUtils.checkObjEmpty(dataObj);
    }

    public static boolean getThemeMapStatus(JSONObject respObj) {
        if (null == respObj) {
            return false;
        }
        return respObj.getBooleanValue("success");
    }

    public static JSONObject getEspRespData(String respContent) {
        JSONObject respObj = Optional.ofNullable(respContent).map(resp -> JSONObject.parseObject((String)resp)).map(obj -> obj.getJSONObject("std_data")).orElse(null);
        return ServiceResponseUtils.checkObjEmpty(respObj);
    }

    public static boolean getEspRespStatus(JSONObject respObj) {
        return Optional.ofNullable(respObj).map(obj -> obj.getJSONObject("execution")).map(obj -> 0 == obj.getIntValue("code")).orElse(false);
    }

    public static JSONObject getEspRespParameter(JSONObject respObj) {
        if (null == respObj) {
            return null;
        }
        JSONObject paramObj = respObj.getJSONObject("parameter");
        return ServiceResponseUtils.checkObjEmpty(paramObj);
    }

    public static JSONObject getBpmResp(String respContent) {
        return ServiceResponseUtils.checkObjEmpty(ServiceResponseUtils.getDapResp(respContent));
    }

    public static JSONObject getDataEventResp(String respContent) {
        return ServiceResponseUtils.checkObjEmpty(ServiceResponseUtils.getDapResp(respContent));
    }

    public static JSONObject getServiceComposerResp(String respContent) {
        return ServiceResponseUtils.checkObjEmpty(ServiceResponseUtils.getDapResp(respContent));
    }

    public static JSONObject getDapResp(String respContent) {
        if (null == respContent) {
            return null;
        }
        String resp = ServiceResponseUtils.getDwServiceResponse(respContent);
        if (null == resp) {
            return null;
        }
        JSONObject paramObj = JSONObject.parseObject((String)resp);
        return paramObj;
    }

    private static JSONObject checkObjEmpty(JSONObject paramObj) {
        if (MapUtils.isEmpty((Map)paramObj)) {
            return null;
        }
        return paramObj;
    }
}

