/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.flowcontrol.init;

import com.digiwin.athena.flowcontrol.factory.FlowControlFactory;
import com.digiwin.athena.flowcontrol.sentinel.intercept.SentinelInterceptConfiguration;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnProperty(name={"flowControl.enable"})
public class FlowInitAutoConfiguration {
    @Value(value="${flowControl.type:1}")
    private String type;
    @Value(value="${app.id}")
    private String appId;

    @Bean(name={"initFlowControl"})
    public String init() {
        FlowControlFactory.createFlowControl(this.type, this.appId).start();
        return "";
    }

    @Bean
    public SentinelInterceptConfiguration flowInterceptConfiguration() {
        return new SentinelInterceptConfiguration();
    }
}

