/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.flowcontrol.init;

import com.alibaba.cloud.commons.lang.StringUtils;
import com.alibaba.cloud.sentinel.datasource.converter.JsonConverter;
import com.alibaba.csp.sentinel.annotation.aspectj.SentinelResourceAspect;
import com.alibaba.csp.sentinel.config.SentinelConfig;
import com.alibaba.csp.sentinel.init.InitExecutor;
import com.alibaba.csp.sentinel.slots.block.authority.AuthorityRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.param.ParamFlowRule;
import com.alibaba.csp.sentinel.slots.system.SystemRule;
import com.digiwin.athena.flowcontrol.init.FlowInitAutoConfiguration;
import com.digiwin.athena.flowcontrol.sentinel.SentinelProperties;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration(proxyBeanMethods=false)
@ConditionalOnProperty(name={"flowControl.enable"})
@AutoConfigureBefore(value={FlowInitAutoConfiguration.class})
@EnableConfigurationProperties(value={SentinelProperties.class})
public class FlowPropAutoConfiguration {
    @Value(value="${project.name:${spring.application.name:}}")
    private String projectName;
    @Autowired
    private SentinelProperties properties;

    @PostConstruct
    public void config() {
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.log.dir")) && StringUtils.isNotBlank((CharSequence)this.properties.getLog().getDir())) {
            System.setProperty("csp.sentinel.log.dir", this.properties.getLog().getDir());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.log.use.pid")) && this.properties.getLog().isSwitchPid()) {
            System.setProperty("csp.sentinel.log.use.pid", String.valueOf(this.properties.getLog().isSwitchPid()));
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.app.name")) && StringUtils.isNotBlank((CharSequence)this.projectName)) {
            System.setProperty("csp.sentinel.app.name", this.projectName);
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.api.port")) && StringUtils.isNotBlank((CharSequence)this.properties.getTransport().getPort())) {
            System.setProperty("csp.sentinel.api.port", this.properties.getTransport().getPort());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.dashboard.server")) && StringUtils.isNotBlank((CharSequence)this.properties.getTransport().getDashboard())) {
            System.setProperty("csp.sentinel.dashboard.server", this.properties.getTransport().getDashboard());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.heartbeat.interval.ms")) && StringUtils.isNotBlank((CharSequence)this.properties.getTransport().getHeartbeatIntervalMs())) {
            System.setProperty("csp.sentinel.heartbeat.interval.ms", this.properties.getTransport().getHeartbeatIntervalMs());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.heartbeat.client.ip")) && StringUtils.isNotBlank((CharSequence)this.properties.getTransport().getClientIp())) {
            System.setProperty("csp.sentinel.heartbeat.client.ip", this.properties.getTransport().getClientIp());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.charset")) && StringUtils.isNotBlank((CharSequence)this.properties.getMetric().getCharset())) {
            System.setProperty("csp.sentinel.charset", this.properties.getMetric().getCharset());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.metric.file.single.size")) && StringUtils.isNotBlank((CharSequence)this.properties.getMetric().getFileSingleSize())) {
            System.setProperty("csp.sentinel.metric.file.single.size", this.properties.getMetric().getFileSingleSize());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.metric.file.total.count")) && StringUtils.isNotBlank((CharSequence)this.properties.getMetric().getFileTotalCount())) {
            System.setProperty("csp.sentinel.metric.file.total.count", this.properties.getMetric().getFileTotalCount());
        }
        if (StringUtils.isEmpty((CharSequence)System.getProperty("csp.sentinel.flow.cold.factor")) && StringUtils.isNotBlank((CharSequence)this.properties.getFlow().getColdFactor())) {
            System.setProperty("csp.sentinel.flow.cold.factor", this.properties.getFlow().getColdFactor());
        }
        if (StringUtils.isNotBlank((CharSequence)this.properties.getBlockPage())) {
            SentinelConfig.setConfig((String)"csp.sentinel.web.servlet.block.page", (String)this.properties.getBlockPage());
        }
        if (this.properties.isEager()) {
            InitExecutor.doInit();
        }
    }

    @Bean
    @ConditionalOnMissingBean
    public SentinelResourceAspect sentinelResourceAspect() {
        return new SentinelResourceAspect();
    }

    @ConditionalOnClass(value={ObjectMapper.class})
    @Configuration(proxyBeanMethods=false)
    protected static class SentinelConverterConfiguration {
        protected SentinelConverterConfiguration() {
        }

        @Configuration(proxyBeanMethods=false)
        protected static class SentinelJsonConfiguration {
            private ObjectMapper objectMapper = new ObjectMapper();

            public SentinelJsonConfiguration() {
                this.objectMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
            }

            @Bean(value={"sentinel-json-flow-converter"})
            public JsonConverter jsonFlowConverter() {
                return new JsonConverter(this.objectMapper, FlowRule.class);
            }

            @Bean(value={"sentinel-json-degrade-converter"})
            public JsonConverter jsonDegradeConverter() {
                return new JsonConverter(this.objectMapper, DegradeRule.class);
            }

            @Bean(value={"sentinel-json-system-converter"})
            public JsonConverter jsonSystemConverter() {
                return new JsonConverter(this.objectMapper, SystemRule.class);
            }

            @Bean(value={"sentinel-json-authority-converter"})
            public JsonConverter jsonAuthorityConverter() {
                return new JsonConverter(this.objectMapper, AuthorityRule.class);
            }

            @Bean(value={"sentinel-json-param-flow-converter"})
            public JsonConverter jsonParamFlowConverter() {
                return new JsonConverter(this.objectMapper, ParamFlowRule.class);
            }
        }
    }
}

