/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.flowcontrol.sentinel.intercept;

import com.alibaba.csp.sentinel.Entry;
import com.alibaba.csp.sentinel.EntryType;
import com.alibaba.csp.sentinel.SphU;
import com.alibaba.csp.sentinel.Tracer;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.callback.UrlCleaner;
import com.alibaba.csp.sentinel.adapter.spring.webmvc.config.SentinelWebMvcConfig;
import com.alibaba.csp.sentinel.context.ContextUtil;
import com.alibaba.csp.sentinel.log.RecordLog;
import com.alibaba.csp.sentinel.slots.block.BlockException;
import com.alibaba.csp.sentinel.util.StringUtil;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.ModelAndView;

public class SentinelWebIntercept
implements HandlerInterceptor {
    private static final String DEFAULT_REQUEST_EXCEPTION_ATTRIBUTE_NAME = "request-exception";
    public static final String SENTINEL_SPRING_WEB_CONTEXT_NAME = "sentinel_spring_web_context";
    private static final String EMPTY_ORIGIN = "";
    private final SentinelWebMvcConfig config;

    public SentinelWebIntercept(SentinelWebMvcConfig config) {
        this.config = config;
    }

    private Integer increaseReferee(HttpServletRequest request, String rcKey, int step) {
        Object obj = request.getAttribute(rcKey);
        if (obj == null) {
            obj = 0;
        }
        Integer newRc = (Integer)obj + step;
        request.setAttribute(rcKey, (Object)newRc);
        return newRc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        try {
            String resourceName = this.getResourceName(request);
            if (StringUtil.isEmpty((String)resourceName)) {
                return true;
            }
            if (this.increaseReferee(request, this.config.getRequestRefName(), 1) != 1) {
                return true;
            }
            String origin = this.parseOrigin(request);
            String contextName = this.getContextName(request);
            ContextUtil.enter((String)contextName, (String)origin);
            Entry entry = SphU.entry((String)resourceName, (int)1, (EntryType)EntryType.IN);
            request.setAttribute(this.config.getRequestAttributeName(), (Object)entry);
            return true;
        }
        catch (BlockException e) {
            try {
                this.handleBlockException(request, response, e);
            }
            finally {
                ContextUtil.exit();
            }
            return false;
        }
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) {
        if (this.increaseReferee(request, this.config.getRequestRefName(), -1) != 0) {
            return;
        }
        Entry entry = this.getEntryInRequest(request, this.config.getRequestAttributeName());
        if (entry == null) {
            RecordLog.warn((String)"[{}] No entry found in request, key: {}", (Object[])new Object[]{this.getClass().getSimpleName(), this.config.getRequestAttributeName()});
            return;
        }
        this.traceExceptionAndExit(request, entry, ex);
        this.removeEntryInRequest(request);
        ContextUtil.exit();
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
    }

    protected Entry getEntryInRequest(HttpServletRequest request, String attrKey) {
        Object entryObject = request.getAttribute(attrKey);
        return entryObject == null ? null : (Entry)entryObject;
    }

    protected void removeEntryInRequest(HttpServletRequest request) {
        request.removeAttribute(this.config.getRequestAttributeName());
    }

    protected void handleBlockException(HttpServletRequest request, HttpServletResponse response, BlockException e) throws Exception {
        if (this.config.getBlockExceptionHandler() == null) {
            throw e;
        }
        this.config.getBlockExceptionHandler().handle(request, response, e);
    }

    protected String parseOrigin(HttpServletRequest request) {
        String origin = EMPTY_ORIGIN;
        if (this.config.getOriginParser() != null && StringUtil.isEmpty((String)(origin = this.config.getOriginParser().parseOrigin(request)))) {
            return EMPTY_ORIGIN;
        }
        return origin;
    }

    protected String getResourceName(HttpServletRequest request) {
        Object resourceNameObject = request.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
        if (!(resourceNameObject instanceof String)) {
            return null;
        }
        String resourceName = (String)resourceNameObject;
        UrlCleaner urlCleaner = this.config.getUrlCleaner();
        if (urlCleaner != null) {
            resourceName = urlCleaner.clean(resourceName);
        }
        if (StringUtil.isNotEmpty((String)resourceName) && this.config.isHttpMethodSpecify()) {
            resourceName = request.getMethod().toUpperCase() + ":" + resourceName;
        }
        return resourceName;
    }

    protected String getContextName(HttpServletRequest request) {
        if (this.config.isWebContextUnify()) {
            return SENTINEL_SPRING_WEB_CONTEXT_NAME;
        }
        return this.getResourceName(request);
    }

    protected void traceExceptionAndExit(HttpServletRequest request, Entry entry, Exception ex) {
        if (entry != null) {
            if (ex != null) {
                Tracer.traceEntry((Throwable)ex, (Entry)entry);
            } else {
                Throwable throwable = (Throwable)request.getAttribute(DEFAULT_REQUEST_EXCEPTION_ATTRIBUTE_NAME);
                Tracer.traceEntry((Throwable)throwable, (Entry)entry);
                request.removeAttribute(DEFAULT_REQUEST_EXCEPTION_ATTRIBUTE_NAME);
            }
            entry.exit();
        }
    }
}

