/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.flowcontrol.sentinel.service.impl;

import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.datasource.apollo.ApolloDataSource;
import com.alibaba.csp.sentinel.property.SentinelProperty;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRule;
import com.alibaba.csp.sentinel.slots.block.degrade.DegradeRuleManager;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.digiwin.athena.common.FlowControlConstant;
import com.digiwin.athena.flowcontrol.sentinel.entity.ClusterGroupEntity;
import com.digiwin.athena.flowcontrol.sentinel.service.impl.SentinelBaseFlowControl;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;

public class SentinelApolloFlowControl
extends SentinelBaseFlowControl {
    private final String appId;

    public SentinelApolloFlowControl(String appId) {
        this.appId = appId;
    }

    @Override
    protected void initFlowLimitRule() {
        ApolloDataSource flowRuleDataSource = new ApolloDataSource(this.appId, "flowRules", "[]", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<FlowRule>>(){}, (Feature[])new Feature[0]));
        FlowRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
    }

    @Override
    protected void initDegradeRule() {
        ApolloDataSource flowRuleDataSource = new ApolloDataSource(this.appId, "degradeRules", "[]", source -> (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<DegradeRule>>(){}, (Feature[])new Feature[0]));
        DegradeRuleManager.register2Property((SentinelProperty)flowRuleDataSource.getProperty());
    }

    @Override
    protected void initClusterState() {
        ClusterStateManager.applyState((Integer)0);
    }

    @Override
    protected void initClusterServerInfo() {
        ApolloDataSource clusterServerDataSource = new ApolloDataSource(this.appId, "clusterMap", "[]", source -> {
            List groupList = (List)JSON.parseObject((String)source, (TypeReference)new TypeReference<List<ClusterGroupEntity>>(){}, (Feature[])new Feature[0]);
            return Optional.ofNullable(groupList).flatMap(this::extractClientAssignment).orElse(null);
        });
        ClusterClientConfigManager.registerServerAssignProperty((SentinelProperty)clusterServerDataSource.getProperty());
    }

    private Optional<ClusterClientAssignConfig> extractClientAssignment(List<ClusterGroupEntity> groupList) {
        Iterator<ClusterGroupEntity> iterator = groupList.iterator();
        if (iterator.hasNext()) {
            ClusterGroupEntity group = iterator.next();
            String ip = group.getIp();
            Integer port = group.getPort();
            return Optional.of(new ClusterClientAssignConfig(ip, port));
        }
        return Optional.empty();
    }

    @Override
    protected void initClusterRequestTimeOut() {
        ApolloDataSource clusterServerDataSource = new ApolloDataSource(this.appId, "clusterClientConfig", "{}", source -> {
            ClusterClientConfig tempConfig = (ClusterClientConfig)JSON.parseObject((String)source, (TypeReference)new TypeReference<ClusterClientConfig>(){}, (Feature[])new Feature[0]);
            return tempConfig.getRequestTimeout() == null ? tempConfig.setRequestTimeout(FlowControlConstant.DEFAULT_REQUEST_TIMEOUT) : tempConfig;
        });
        ClusterClientConfigManager.registerClientConfigProperty((SentinelProperty)clusterServerDataSource.getProperty());
    }
}

