package com.digiwin.athena.flowlimit;

import com.alibaba.csp.sentinel.cluster.ClusterStateManager;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientAssignConfig;
import com.alibaba.csp.sentinel.cluster.client.config.ClusterClientConfigManager;
import com.alibaba.csp.sentinel.slots.block.ClusterRuleConstant;
import com.alibaba.csp.sentinel.slots.block.RuleConstant;
import com.alibaba.csp.sentinel.slots.block.flow.ClusterFlowConfig;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRule;
import com.alibaba.csp.sentinel.slots.block.flow.FlowRuleManager;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * author:gonghongxing
 * date:2024/6/12
 * description:
 **/
@Component
public class ClusterClient {

    /**
     * CLuster server address
     */
    private static final String CLUSTER_SERVER_HOST = "192.168.200.62";

    /**
     * cluster server port
     */
    private static final int CLUSTER_SERVER_PORT = 11111;

    public void init() {

        //设置流控规则
        initFlowRuleInfo();
        //设置token server服务端信息
        initClusterServerInfo();
        //设置客户端标记
        initClusterState();
    }

    /**
     * 设置流控规则信息
     */
    private void initFlowRuleInfo() {

        List<FlowRule> ruleList = new ArrayList<>();

        //设置集群限流规则
        ruleList.add(setClusterRule());

        //规则管理器加载规则
        FlowRuleManager.loadRules(ruleList);
    }


    /**
     * 设置集群限流规则
     *
     * @return clusterFlowRule 集群限流规则
     */
    private FlowRule setClusterRule() {

        FlowRule clusterFlowRule = new FlowRule();
        clusterFlowRule.setClusterMode(true);
        ClusterFlowConfig clusterFlowConfig = new ClusterFlowConfig();
        clusterFlowConfig.setFlowId(123456L);
        clusterFlowConfig.setStrategy(ClusterRuleConstant.FLOW_CLUSTER_STRATEGY_NORMAL);
        clusterFlowConfig.setThresholdType(ClusterRuleConstant.FLOW_THRESHOLD_GLOBAL);
        clusterFlowRule.setClusterConfig(clusterFlowConfig);
        clusterFlowRule.setResource("sayHello");
        clusterFlowRule.setCount(8d);
        clusterFlowRule.setGrade(RuleConstant.FLOW_GRADE_QPS);
        return clusterFlowRule;

    }

    /**
     * 设置状态为集群客户端 CLUSTER_CLIENT/CLUSTER_SERVER
     */
    private void initClusterState() {
        ClusterStateManager.applyState(ClusterStateManager.CLUSTER_CLIENT);
    }

    /**
     * 设置集群TokenServer 服务端的信息
     */
    private void initClusterServerInfo() {
        ClusterClientAssignConfig clusterClientAssignConfig = new ClusterClientAssignConfig();
        clusterClientAssignConfig.setServerHost(CLUSTER_SERVER_HOST);
        clusterClientAssignConfig.setServerPort(CLUSTER_SERVER_PORT);
        ClusterClientConfigManager.applyNewAssignConfig(clusterClientAssignConfig);
    }

//    /**
//     * Callback used to run the bean.
//     *
//     * @param args incoming application arguments
//     */
//    @Override
//    public void run(ApplicationArguments args) {
//        init();
//    }
}
